@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Admin credentials for virtual machine
 * @property password Password of admin account
 * @property privateKeyData Private key data
 * @property publicKeyData Public key data
 * @property username Username of admin account
 */
public data class VirtualMachineSshCredentialsResponse(
    public val password: String? = null,
    public val privateKeyData: String? = null,
    public val publicKeyData: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.VirtualMachineSshCredentialsResponse): VirtualMachineSshCredentialsResponse = VirtualMachineSshCredentialsResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            privateKeyData = javaType.privateKeyData().map({ args0 -> args0 }).orElse(null),
            publicKeyData = javaType.publicKeyData().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
