@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes the volume configuration for the container
 * @property bind Bind Options of the mount
 * @property consistency Consistency of the volume
 * @property readOnly Indicate whether to mount volume as readOnly. Default value for this is false.
 * @property source Source of the mount. For bind mounts this is the host path.
 * @property target Target of the mount. For bind mounts this is the path in the container.
 * @property tmpfs tmpfs option of the mount
 * @property type Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
 * @property volume Volume Options of the mount
 */
public data class VolumeDefinitionResponse(
    public val bind: BindOptionsResponse? = null,
    public val consistency: String? = null,
    public val readOnly: Boolean? = null,
    public val source: String? = null,
    public val target: String? = null,
    public val tmpfs: TmpfsOptionsResponse? = null,
    public val type: String? = null,
    public val volume: VolumeOptionsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.VolumeDefinitionResponse): VolumeDefinitionResponse = VolumeDefinitionResponse(
            bind = javaType.bind().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.BindOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            consistency = javaType.consistency().map({ args0 -> args0 }).orElse(null),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            tmpfs = javaType.tmpfs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.TmpfsOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            volume = javaType.volume().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.VolumeOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
