@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.kotlin.outputs.InputPatchConfigurationResponse
import com.pulumi.azurenative.maintenance.kotlin.outputs.MaintenanceOverridePropertiesResponse
import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.maintenance.kotlin.outputs.InputPatchConfigurationResponse.Companion.toKotlin as inputPatchConfigurationResponseToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.MaintenanceOverridePropertiesResponse.Companion.toKotlin as maintenanceOverridePropertiesResponseToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MaintenanceConfiguration].
 */
@PulumiTagMarker
public class MaintenanceConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MaintenanceConfigurationArgs = MaintenanceConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MaintenanceConfigurationArgsBuilder.() -> Unit) {
        val builder = MaintenanceConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MaintenanceConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.maintenance.MaintenanceConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MaintenanceConfiguration(builtJavaResource)
    }
}

/**
 * Maintenance configuration record type
 * Azure REST API version: 2022-11-01-preview. Prior API version in Azure Native 1.x: 2020-04-01.
 * Other available API versions: 2023-04-01, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### MaintenanceConfigurations_CreateOrUpdateForResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var maintenanceConfiguration = new AzureNative.Maintenance.MaintenanceConfiguration("maintenanceConfiguration", new()
 *     {
 *         Duration = "05:00",
 *         ExpirationDateTime = "9999-12-31 00:00",
 *         Location = "westus2",
 *         MaintenanceScope = AzureNative.Maintenance.MaintenanceScope.OSImage,
 *         Namespace = "Microsoft.Maintenance",
 *         RecurEvery = "Day",
 *         ResourceGroupName = "examplerg",
 *         ResourceName = "configuration1",
 *         StartDateTime = "2020-04-30 08:00",
 *         TimeZone = "Pacific Standard Time",
 *         Visibility = AzureNative.Maintenance.Visibility.Custom,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewMaintenanceConfiguration(ctx, "maintenanceConfiguration", &maintenance.MaintenanceConfigurationArgs{
 * 			Duration:           pulumi.String("05:00"),
 * 			ExpirationDateTime: pulumi.String("9999-12-31 00:00"),
 * 			Location:           pulumi.String("westus2"),
 * 			MaintenanceScope:   pulumi.String(maintenance.MaintenanceScopeOSImage),
 * 			Namespace:          pulumi.String("Microsoft.Maintenance"),
 * 			RecurEvery:         pulumi.String("Day"),
 * 			ResourceGroupName:  pulumi.String("examplerg"),
 * 			ResourceName:       pulumi.String("configuration1"),
 * 			StartDateTime:      pulumi.String("2020-04-30 08:00"),
 * 			TimeZone:           pulumi.String("Pacific Standard Time"),
 * 			Visibility:         pulumi.String(maintenance.VisibilityCustom),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.MaintenanceConfiguration;
 * import com.pulumi.azurenative.maintenance.MaintenanceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var maintenanceConfiguration = new MaintenanceConfiguration("maintenanceConfiguration", MaintenanceConfigurationArgs.builder()
 *             .duration("05:00")
 *             .expirationDateTime("9999-12-31 00:00")
 *             .location("westus2")
 *             .maintenanceScope("OSImage")
 *             .namespace("Microsoft.Maintenance")
 *             .recurEvery("Day")
 *             .resourceGroupName("examplerg")
 *             .resourceName("configuration1")
 *             .startDateTime("2020-04-30 08:00")
 *             .timeZone("Pacific Standard Time")
 *             .visibility("Custom")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:MaintenanceConfiguration configuration1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Maintenance/maintenanceConfigurations/{resourceName}
 * ```
 */
public class MaintenanceConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.maintenance.MaintenanceConfiguration,
) : KotlinCustomResource(javaResource, MaintenanceConfigurationMapper) {
    /**
     * Duration of the maintenance window in HH:mm format. If not provided, default value will be used based on maintenance scope provided. Example: 05:00.
     */
    public val duration: Output<String>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
     */
    public val expirationDateTime: Output<String>?
        get() = javaResource.expirationDateTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets extensionProperties of the maintenanceConfiguration
     */
    public val extensionProperties: Output<Map<String, String>>?
        get() = javaResource.extensionProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The input parameters to be passed to the patch run operation.
     */
    public val installPatches: Output<InputPatchConfigurationResponse>?
        get() = javaResource.installPatches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> inputPatchConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets location of the resource
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets maintenanceScope of the configuration
     */
    public val maintenanceScope: Output<String>?
        get() = javaResource.maintenanceScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets namespace of the resource
     */
    public val namespace: Output<String>?
        get() = javaResource.namespace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Override Properties for the maintenance Configuration.
     */
    public val overrides: Output<List<MaintenanceOverridePropertiesResponse>>?
        get() = javaResource.overrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        maintenanceOverridePropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Rate at which a Maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery: [Frequency as integer]['Day(s)']&#46; If no frequency is provided, the default frequency is 1&#46; Daily schedule examples are recurEvery: Day, recurEvery: 3Days&#46;  Weekly schedule are formatted as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays Monday-Sunday]&#46; Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week Saturday,Sunday&#46; Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First, Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No&#46; of days)]. Offset value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month, recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery: Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday Offset6.
     */
    public val recurEvery: Output<String>?
        get() = javaResource.recurEvery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Effective start date of the maintenance window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
     */
    public val startDateTime: Output<String>?
        get() = javaResource.startDateTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets tags of the resource
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
     */
    public val timeZone: Output<String>?
        get() = javaResource.timeZone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of the resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the visibility of the configuration. The default value is 'Custom'
     */
    public val visibility: Output<String>?
        get() = javaResource.visibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MaintenanceConfigurationMapper : ResourceMapper<MaintenanceConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.maintenance.MaintenanceConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): MaintenanceConfiguration =
        MaintenanceConfiguration(
            javaResource as
                com.pulumi.azurenative.maintenance.MaintenanceConfiguration,
        )
}

/**
 * @see [MaintenanceConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MaintenanceConfiguration].
 */
public suspend fun maintenanceConfiguration(
    name: String,
    block: suspend MaintenanceConfigurationResourceBuilder.() -> Unit,
): MaintenanceConfiguration {
    val builder = MaintenanceConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MaintenanceConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun maintenanceConfiguration(name: String): MaintenanceConfiguration {
    val builder = MaintenanceConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
