@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets maintenanceScope of the configuration
 */
public enum class MaintenanceScope(
    public val javaValue: com.pulumi.azurenative.maintenance.enums.MaintenanceScope,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.enums.MaintenanceScope> {
    /**
     * This maintenance scope controls installation of azure platform updates i.e. services on physical nodes hosting customer VMs.
     */
    Host(com.pulumi.azurenative.maintenance.enums.MaintenanceScope.Host),

    /**
     * This maintenance scope controls the default update maintenance of the Azure Resource
     */
    Resource(com.pulumi.azurenative.maintenance.enums.MaintenanceScope.Resource),

    /**
     * This maintenance scope controls os image installation on VM/VMSS
     */
    OSImage(com.pulumi.azurenative.maintenance.enums.MaintenanceScope.OSImage),

    /**
     * This maintenance scope controls extension installation on VM/VMSS
     */
    Extension(com.pulumi.azurenative.maintenance.enums.MaintenanceScope.Extension),

    /**
     * This maintenance scope controls installation of windows and linux packages on VM/VMSS
     */
    InGuestPatch(com.pulumi.azurenative.maintenance.enums.MaintenanceScope.InGuestPatch),

    /**
     * This maintenance scope controls installation of SQL server platform updates.
     */
    SQLDB(com.pulumi.azurenative.maintenance.enums.MaintenanceScope.SQLDB),

    /**
     * This maintenance scope controls installation of SQL managed instance platform update.
     */
    SQLManagedInstance(com.pulumi.azurenative.maintenance.enums.MaintenanceScope.SQLManagedInstance),
    ;

    override fun toJava(): com.pulumi.azurenative.maintenance.enums.MaintenanceScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.enums.MaintenanceScope): MaintenanceScope = MaintenanceScope.values().first { it.javaValue == javaType }
    }
}
