@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the visibility of the configuration. The default value is 'Custom'
 */
public enum class Visibility(
    public val javaValue: com.pulumi.azurenative.maintenance.enums.Visibility,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.enums.Visibility> {
    /**
     * Only visible to users with permissions.
     */
    Custom(com.pulumi.azurenative.maintenance.enums.Visibility.Custom),

    /**
     * Visible to all users.
     */
    Public(com.pulumi.azurenative.maintenance.enums.Visibility.Public),
    ;

    override fun toJava(): com.pulumi.azurenative.maintenance.enums.Visibility = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.enums.Visibility): Visibility =
            Visibility.values().first { it.javaValue == javaType }
    }
}
