@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.InputLinuxParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input properties for patching a Linux machine.
 * @property classificationsToInclude Classification category of patches to be patched
 * @property packageNameMasksToExclude Package names to be excluded for patching.
 * @property packageNameMasksToInclude Package names to be included for patching.
 */
public data class InputLinuxParametersArgs(
    public val classificationsToInclude: Output<List<String>>? = null,
    public val packageNameMasksToExclude: Output<List<String>>? = null,
    public val packageNameMasksToInclude: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.InputLinuxParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.inputs.InputLinuxParametersArgs =
        com.pulumi.azurenative.maintenance.inputs.InputLinuxParametersArgs.builder()
            .classificationsToInclude(
                classificationsToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .packageNameMasksToExclude(
                packageNameMasksToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .packageNameMasksToInclude(
                packageNameMasksToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [InputLinuxParametersArgs].
 */
@PulumiTagMarker
public class InputLinuxParametersArgsBuilder internal constructor() {
    private var classificationsToInclude: Output<List<String>>? = null

    private var packageNameMasksToExclude: Output<List<String>>? = null

    private var packageNameMasksToInclude: Output<List<String>>? = null

    /**
     * @param value Classification category of patches to be patched
     */
    @JvmName("fxmtgasqukvkyhvs")
    public suspend fun classificationsToInclude(`value`: Output<List<String>>) {
        this.classificationsToInclude = value
    }

    @JvmName("vydjfaaxrrlrkjjq")
    public suspend fun classificationsToInclude(vararg values: Output<String>) {
        this.classificationsToInclude = Output.all(values.asList())
    }

    /**
     * @param values Classification category of patches to be patched
     */
    @JvmName("hpidxaikuhlktnal")
    public suspend fun classificationsToInclude(values: List<Output<String>>) {
        this.classificationsToInclude = Output.all(values)
    }

    /**
     * @param value Package names to be excluded for patching.
     */
    @JvmName("syomdoakdrfibmve")
    public suspend fun packageNameMasksToExclude(`value`: Output<List<String>>) {
        this.packageNameMasksToExclude = value
    }

    @JvmName("nubvdxwdmpqvmsel")
    public suspend fun packageNameMasksToExclude(vararg values: Output<String>) {
        this.packageNameMasksToExclude = Output.all(values.asList())
    }

    /**
     * @param values Package names to be excluded for patching.
     */
    @JvmName("crtgkdrutocxvhij")
    public suspend fun packageNameMasksToExclude(values: List<Output<String>>) {
        this.packageNameMasksToExclude = Output.all(values)
    }

    /**
     * @param value Package names to be included for patching.
     */
    @JvmName("lcwcbslvhdhvauac")
    public suspend fun packageNameMasksToInclude(`value`: Output<List<String>>) {
        this.packageNameMasksToInclude = value
    }

    @JvmName("rkavpxkbkiiqsvjj")
    public suspend fun packageNameMasksToInclude(vararg values: Output<String>) {
        this.packageNameMasksToInclude = Output.all(values.asList())
    }

    /**
     * @param values Package names to be included for patching.
     */
    @JvmName("oqemxmfljewdpmht")
    public suspend fun packageNameMasksToInclude(values: List<Output<String>>) {
        this.packageNameMasksToInclude = Output.all(values)
    }

    /**
     * @param value Classification category of patches to be patched
     */
    @JvmName("vjtuwqviyjtaogxx")
    public suspend fun classificationsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classificationsToInclude = mapped
    }

    /**
     * @param values Classification category of patches to be patched
     */
    @JvmName("fbqsuxjlolqvltym")
    public suspend fun classificationsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classificationsToInclude = mapped
    }

    /**
     * @param value Package names to be excluded for patching.
     */
    @JvmName("oowkmevwsqlxxddb")
    public suspend fun packageNameMasksToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageNameMasksToExclude = mapped
    }

    /**
     * @param values Package names to be excluded for patching.
     */
    @JvmName("obuocmhvkwrtciqc")
    public suspend fun packageNameMasksToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageNameMasksToExclude = mapped
    }

    /**
     * @param value Package names to be included for patching.
     */
    @JvmName("jahowsndhcbpghhl")
    public suspend fun packageNameMasksToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageNameMasksToInclude = mapped
    }

    /**
     * @param values Package names to be included for patching.
     */
    @JvmName("bavmlvwhkpoaohse")
    public suspend fun packageNameMasksToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageNameMasksToInclude = mapped
    }

    internal fun build(): InputLinuxParametersArgs = InputLinuxParametersArgs(
        classificationsToInclude = classificationsToInclude,
        packageNameMasksToExclude = packageNameMasksToExclude,
        packageNameMasksToInclude = packageNameMasksToInclude,
    )
}
