@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration Assignment
 * @property id Fully qualified identifier of the resource
 * @property location Location of the resource
 * @property maintenanceConfigurationId The maintenance configuration Id
 * @property name Name of the resource
 * @property resourceId The unique resourceId
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type Type of the resource
 */
public data class GetConfigurationAssignmentParentResult(
    public val id: String,
    public val location: String? = null,
    public val maintenanceConfigurationId: String? = null,
    public val name: String,
    public val resourceId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.outputs.GetConfigurationAssignmentParentResult): GetConfigurationAssignmentParentResult = GetConfigurationAssignmentParentResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            maintenanceConfigurationId = javaType.maintenanceConfigurationId().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
