@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input properties for patching a Linux machine.
 * @property classificationsToInclude Classification category of patches to be patched
 * @property packageNameMasksToExclude Package names to be excluded for patching.
 * @property packageNameMasksToInclude Package names to be included for patching.
 */
public data class InputLinuxParametersResponse(
    public val classificationsToInclude: List<String>? = null,
    public val packageNameMasksToExclude: List<String>? = null,
    public val packageNameMasksToInclude: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.outputs.InputLinuxParametersResponse): InputLinuxParametersResponse = InputLinuxParametersResponse(
            classificationsToInclude = javaType.classificationsToInclude().map({ args0 -> args0 }),
            packageNameMasksToExclude = javaType.packageNameMasksToExclude().map({ args0 -> args0 }),
            packageNameMasksToInclude = javaType.packageNameMasksToInclude().map({ args0 -> args0 }),
        )
    }
}
