@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input properties for patching a Windows machine.
 * @property classificationsToInclude Classification category of patches to be patched
 * @property excludeKbsRequiringReboot Exclude patches which need reboot
 * @property kbNumbersToExclude Windows KBID to be excluded for patching.
 * @property kbNumbersToInclude Windows KBID to be included for patching.
 */
public data class InputWindowsParametersResponse(
    public val classificationsToInclude: List<String>? = null,
    public val excludeKbsRequiringReboot: Boolean? = null,
    public val kbNumbersToExclude: List<String>? = null,
    public val kbNumbersToInclude: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.outputs.InputWindowsParametersResponse): InputWindowsParametersResponse = InputWindowsParametersResponse(
            classificationsToInclude = javaType.classificationsToInclude().map({ args0 -> args0 }),
            excludeKbsRequiringReboot = javaType.excludeKbsRequiringReboot().map({ args0 ->
                args0
            }).orElse(null),
            kbNumbersToExclude = javaType.kbNumbersToExclude().map({ args0 -> args0 }),
            kbNumbersToInclude = javaType.kbNumbersToInclude().map({ args0 -> args0 }),
        )
    }
}
