@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Definition of a MaintenanceOverrideProperties
 * @property endDateTime Effective end date of the maintenance override window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
 * @property overrideProperties Gets or sets overrideProperties of the maintenanceConfiguration
 * @property startDateTime Effective start date of the maintenance override window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
 * @property timeZone Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
 */
public data class MaintenanceOverridePropertiesResponse(
    public val endDateTime: String? = null,
    public val overrideProperties: Map<String, String>? = null,
    public val startDateTime: String? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.outputs.MaintenanceOverridePropertiesResponse): MaintenanceOverridePropertiesResponse = MaintenanceOverridePropertiesResponse(
            endDateTime = javaType.endDateTime().map({ args0 -> args0 }).orElse(null),
            overrideProperties = javaType.overrideProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            startDateTime = javaType.startDateTime().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
