@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin

import com.pulumi.azurenative.managedidentity.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managedidentity.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [UserAssignedIdentity].
 */
@PulumiTagMarker
public class UserAssignedIdentityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserAssignedIdentityArgs = UserAssignedIdentityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserAssignedIdentityArgsBuilder.() -> Unit) {
        val builder = UserAssignedIdentityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserAssignedIdentity {
        val builtJavaResource =
            com.pulumi.azurenative.managedidentity.UserAssignedIdentity(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return UserAssignedIdentity(builtJavaResource)
    }
}

/**
 * Describes an identity resource.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2018-11-30.
 * Other available API versions: 2015-08-31-preview, 2023-07-31-preview.
 * ## Example Usage
 * ### IdentityCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userAssignedIdentity = new AzureNative.ManagedIdentity.UserAssignedIdentity("userAssignedIdentity", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "rgName",
 *         ResourceName = "resourceName",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managedidentity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managedidentity.NewUserAssignedIdentity(ctx, "userAssignedIdentity", &managedidentity.UserAssignedIdentityArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rgName"),
 * 			ResourceName:      pulumi.String("resourceName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managedidentity.UserAssignedIdentity;
 * import com.pulumi.azurenative.managedidentity.UserAssignedIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userAssignedIdentity = new UserAssignedIdentity("userAssignedIdentity", UserAssignedIdentityArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("rgName")
 *             .resourceName("resourceName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managedidentity:UserAssignedIdentity identityName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}
 * ```
 */
public class UserAssignedIdentity internal constructor(
    override val javaResource: com.pulumi.azurenative.managedidentity.UserAssignedIdentity,
) : KotlinCustomResource(javaResource, UserAssignedIdentityMapper) {
    /**
     * The id of the app associated with the identity. This is a random generated UUID by MSI.
     */
    public val clientId: Output<String>
        get() = javaResource.clientId().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The id of the service principal object associated with the created identity.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The id of the tenant which the identity belongs to.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UserAssignedIdentityMapper : ResourceMapper<UserAssignedIdentity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managedidentity.UserAssignedIdentity::class == javaResource::class

    override fun map(javaResource: Resource): UserAssignedIdentity = UserAssignedIdentity(
        javaResource
            as com.pulumi.azurenative.managedidentity.UserAssignedIdentity,
    )
}

/**
 * @see [UserAssignedIdentity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserAssignedIdentity].
 */
public suspend fun userAssignedIdentity(
    name: String,
    block: suspend UserAssignedIdentityResourceBuilder.() -> Unit,
): UserAssignedIdentity {
    val builder = UserAssignedIdentityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserAssignedIdentity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userAssignedIdentity(name: String): UserAssignedIdentity {
    val builder = UserAssignedIdentityResourceBuilder()
    builder.name(name)
    return builder.build()
}
