@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin.inputs

import com.pulumi.azurenative.managedidentity.inputs.GetUserAssignedIdentityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the Resource Group to which the identity belongs.
 * @property resourceName The name of the identity resource.
 */
public data class GetUserAssignedIdentityPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managedidentity.inputs.GetUserAssignedIdentityPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managedidentity.inputs.GetUserAssignedIdentityPlainArgs =
        com.pulumi.azurenative.managedidentity.inputs.GetUserAssignedIdentityPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserAssignedIdentityPlainArgs].
 */
@PulumiTagMarker
public class GetUserAssignedIdentityPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the Resource Group to which the identity belongs.
     */
    @JvmName("edsjkohdarxotfmg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the identity resource.
     */
    @JvmName("eolbeakcfehfmxdx")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetUserAssignedIdentityPlainArgs = GetUserAssignedIdentityPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
