@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an Azure resource that is attached to an identity.
 * @property id The ID of this resource.
 * @property name The name of this resource.
 * @property resourceGroup The name of the resource group this resource belongs to.
 * @property subscriptionDisplayName The name of the subscription this resource belongs to.
 * @property subscriptionId The ID of the subscription this resource belongs to.
 * @property type The type of this resource.
 */
public data class AzureResourceResponse(
    public val id: String,
    public val name: String,
    public val resourceGroup: String,
    public val subscriptionDisplayName: String,
    public val subscriptionId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedidentity.outputs.AzureResourceResponse): AzureResourceResponse = AzureResourceResponse(
            id = javaType.id(),
            name = javaType.name(),
            resourceGroup = javaType.resourceGroup(),
            subscriptionDisplayName = javaType.subscriptionDisplayName(),
            subscriptionId = javaType.subscriptionId(),
            type = javaType.type(),
        )
    }
}
