@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a federated identity credential.
 * @property audiences The list of audiences that can appear in the issued token.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property issuer The URL of the issuer to be trusted.
 * @property name The name of the resource
 * @property subject The identifier of the external identity.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFederatedIdentityCredentialResult(
    public val audiences: List<String>,
    public val id: String,
    public val issuer: String,
    public val name: String,
    public val subject: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedidentity.outputs.GetFederatedIdentityCredentialResult): GetFederatedIdentityCredentialResult = GetFederatedIdentityCredentialResult(
            audiences = javaType.audiences().map({ args0 -> args0 }),
            id = javaType.id(),
            issuer = javaType.issuer(),
            name = javaType.name(),
            subject = javaType.subject(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managedidentity.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
