@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes an identity resource.
 * @property clientId The id of the app associated with the identity. This is a random generated UUID by MSI.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property principalId The id of the service principal object associated with the created identity.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property tenantId The id of the tenant which the identity belongs to.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetUserAssignedIdentityResult(
    public val clientId: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val principalId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedidentity.outputs.GetUserAssignedIdentityResult): GetUserAssignedIdentityResult = GetUserAssignedIdentityResult(
            clientId = javaType.clientId(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            principalId = javaType.principalId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managedidentity.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
