@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure resources returned by the resource action to get a list of assigned resources.
 * @property nextLink The url to get the next page of results, if any.
 * @property totalCount Total number of Azure resources assigned to the identity.
 * @property value The collection of Azure resources returned by the resource action to get a list of assigned resources.
 */
public data class ListUserAssignedIdentityAssociatedResourcesResult(
    public val nextLink: String,
    public val totalCount: Double,
    public val `value`: List<AzureResourceResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managedidentity.outputs.ListUserAssignedIdentityAssociatedResourcesResult): ListUserAssignedIdentityAssociatedResourcesResult =
            ListUserAssignedIdentityAssociatedResourcesResult(
                nextLink = javaType.nextLink(),
                totalCount = javaType.totalCount(),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.managedidentity.kotlin.outputs.AzureResourceResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
