@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.kotlin.outputs.ManagedNetworkPeeringPolicyPropertiesResponse
import com.pulumi.azurenative.managednetwork.kotlin.outputs.ManagedNetworkPeeringPolicyPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedNetworkPeeringPolicy].
 */
@PulumiTagMarker
public class ManagedNetworkPeeringPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedNetworkPeeringPolicyArgs = ManagedNetworkPeeringPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedNetworkPeeringPolicyArgsBuilder.() -> Unit) {
        val builder = ManagedNetworkPeeringPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedNetworkPeeringPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedNetworkPeeringPolicy(builtJavaResource)
    }
}

/**
 * The Managed Network Peering Policy resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ManagedNetworkPeeringPoliciesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetworkPeeringPolicy = new AzureNative.ManagedNetwork.ManagedNetworkPeeringPolicy("managedNetworkPeeringPolicy", new()
 *     {
 *         ManagedNetworkName = "myManagedNetwork",
 *         ManagedNetworkPeeringPolicyName = "myHubAndSpoke",
 *         Properties = new AzureNative.ManagedNetwork.Inputs.ManagedNetworkPeeringPolicyPropertiesArgs
 *         {
 *             Hub = new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myHubVnet",
 *             },
 *             Spokes = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork/managedNetworkGroups/myManagedNetworkGroup1",
 *                 },
 *             },
 *             Type = AzureNative.ManagedNetwork.Type.HubAndSpokeTopology,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewManagedNetworkPeeringPolicy(ctx, "managedNetworkPeeringPolicy", &managednetwork.ManagedNetworkPeeringPolicyArgs{
 * 			ManagedNetworkName:              pulumi.String("myManagedNetwork"),
 * 			ManagedNetworkPeeringPolicyName: pulumi.String("myHubAndSpoke"),
 * 			Properties: &managednetwork.ManagedNetworkPeeringPolicyPropertiesArgs{
 * 				Hub: &managednetwork.ResourceIdArgs{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myHubVnet"),
 * 				},
 * 				Spokes: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork/managedNetworkGroups/myManagedNetworkGroup1"),
 * 					},
 * 				},
 * 				Type: pulumi.String(managednetwork.TypeHubAndSpokeTopology),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicy;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicyArgs;
 * import com.pulumi.azurenative.managednetwork.inputs.ManagedNetworkPeeringPolicyPropertiesArgs;
 * import com.pulumi.azurenative.managednetwork.inputs.ResourceIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetworkPeeringPolicy = new ManagedNetworkPeeringPolicy("managedNetworkPeeringPolicy", ManagedNetworkPeeringPolicyArgs.builder()
 *             .managedNetworkName("myManagedNetwork")
 *             .managedNetworkPeeringPolicyName("myHubAndSpoke")
 *             .properties(ManagedNetworkPeeringPolicyPropertiesArgs.builder()
 *                 .hub(ResourceIdArgs.builder()
 *                     .id("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myHubVnet")
 *                     .build())
 *                 .spokes(ResourceIdArgs.builder()
 *                     .id("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork/managedNetworkGroups/myManagedNetworkGroup1")
 *                     .build())
 *                 .type("HubAndSpokeTopology")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ManagedNetworkPeeringPolicy myHubAndSpoke /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}/managedNetworkPeeringPolicies/{managedNetworkPeeringPolicyName}
 * ```
 */
public class ManagedNetworkPeeringPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicy,
) : KotlinCustomResource(javaResource, ManagedNetworkPeeringPolicyMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the properties of a Managed Network Policy
     */
    public val properties: Output<ManagedNetworkPeeringPolicyPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedNetworkPeeringPolicyMapper : ResourceMapper<ManagedNetworkPeeringPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ManagedNetworkPeeringPolicy =
        ManagedNetworkPeeringPolicy(
            javaResource as
                com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicy,
        )
}

/**
 * @see [ManagedNetworkPeeringPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedNetworkPeeringPolicy].
 */
public suspend fun managedNetworkPeeringPolicy(
    name: String,
    block: suspend ManagedNetworkPeeringPolicyResourceBuilder.() -> Unit,
): ManagedNetworkPeeringPolicy {
    val builder = ManagedNetworkPeeringPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedNetworkPeeringPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedNetworkPeeringPolicy(name: String): ManagedNetworkPeeringPolicy {
    val builder = ManagedNetworkPeeringPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
