@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.inputs

import com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPeeringPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managedNetworkName The name of the Managed Network.
 * @property managedNetworkPeeringPolicyName The name of the Managed Network Peering Policy.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetManagedNetworkPeeringPolicyPlainArgs(
    public val managedNetworkName: String,
    public val managedNetworkPeeringPolicyName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPeeringPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPeeringPolicyPlainArgs =
        com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkPeeringPolicyPlainArgs.builder()
            .managedNetworkName(managedNetworkName.let({ args0 -> args0 }))
            .managedNetworkPeeringPolicyName(managedNetworkPeeringPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedNetworkPeeringPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetManagedNetworkPeeringPolicyPlainArgsBuilder internal constructor() {
    private var managedNetworkName: String? = null

    private var managedNetworkPeeringPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("riqsoliyqwgfyxnm")
    public suspend fun managedNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedNetworkName = mapped
    }

    /**
     * @param value The name of the Managed Network Peering Policy.
     */
    @JvmName("bjlsxlqrfxelsteq")
    public suspend fun managedNetworkPeeringPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedNetworkPeeringPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qitwrlapsgefybda")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedNetworkPeeringPolicyPlainArgs =
        GetManagedNetworkPeeringPolicyPlainArgs(
            managedNetworkName = managedNetworkName ?: throw PulumiNullFieldException("managedNetworkName"),
            managedNetworkPeeringPolicyName = managedNetworkPeeringPolicyName ?: throw
                PulumiNullFieldException("managedNetworkPeeringPolicyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
