@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Managed Network resource
 * @property connectivity The collection of groups and policies concerned with connectivity
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the ManagedNetwork resource.
 * @property scope The collection of management groups, subscriptions, virtual networks, and subnets by the Managed Network. This is a read-only property that is reflective of all ScopeAssignments for this Managed Network
 * @property tags Resource tags
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetManagedNetworkResult(
    public val connectivity: ConnectivityCollectionResponse,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val scope: ScopeResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.outputs.GetManagedNetworkResult): GetManagedNetworkResult = GetManagedNetworkResult(
            connectivity = javaType.connectivity().let({ args0 ->
                com.pulumi.azurenative.managednetwork.kotlin.outputs.ConnectivityCollectionResponse.Companion.toKotlin(args0)
            }),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scope = javaType.scope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ScopeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
