@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Managed Network resource
 * @property assignedManagedNetwork The managed network ID with scope will be assigned to.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the ManagedNetwork resource.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetScopeAssignmentResult(
    public val assignedManagedNetwork: String? = null,
    public val etag: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.outputs.GetScopeAssignmentResult): GetScopeAssignmentResult = GetScopeAssignmentResult(
            assignedManagedNetwork = javaType.assignedManagedNetwork().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
