@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Managed Network Group resource
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Responsibility role under which this Managed Network Group will be created
 * @property location The geo-location where the resource lives
 * @property managementGroups The collection of management groups covered by the Managed Network
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the ManagedNetwork resource.
 * @property subnets The collection of  subnets covered by the Managed Network
 * @property subscriptions The collection of subscriptions covered by the Managed Network
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 * @property virtualNetworks The collection of virtual nets covered by the Managed Network
 */
public data class ManagedNetworkGroupResponse(
    public val etag: String,
    public val id: String,
    public val kind: String? = null,
    public val location: String? = null,
    public val managementGroups: List<ResourceIdResponse>? = null,
    public val name: String,
    public val provisioningState: String,
    public val subnets: List<ResourceIdResponse>? = null,
    public val subscriptions: List<ResourceIdResponse>? = null,
    public val type: String,
    public val virtualNetworks: List<ResourceIdResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.outputs.ManagedNetworkGroupResponse): ManagedNetworkGroupResponse = ManagedNetworkGroupResponse(
            etag = javaType.etag(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managementGroups = javaType.managementGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            subscriptions = javaType.subscriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            virtualNetworks = javaType.virtualNetworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
