@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ExternalNetworkPropertiesResponseOptionAProperties
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.OptionBPropertiesResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ExternalNetworkPropertiesResponseOptionAProperties.Companion.toKotlin as externalNetworkPropertiesResponseOptionAPropertiesToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.OptionBPropertiesResponse.Companion.toKotlin as optionBPropertiesResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ExternalNetwork].
 */
@PulumiTagMarker
public class ExternalNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExternalNetworkArgs = ExternalNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExternalNetworkArgsBuilder.() -> Unit) {
        val builder = ExternalNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExternalNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.ExternalNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExternalNetwork(builtJavaResource)
    }
}

/**
 * Defines the ExternalNetwork item.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### ExternalNetworks_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var externalNetwork = new AzureNative.ManagedNetworkFabric.ExternalNetwork("externalNetwork", new()
 *     {
 *         ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName",
 *         ExternalNetworkName = "example-externalnetwork",
 *         ImportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName",
 *         L3IsolationDomainName = "example-l3domain",
 *         OptionAProperties = new AzureNative.ManagedNetworkFabric.Inputs.ExternalNetworkPropertiesOptionAPropertiesArgs
 *         {
 *             Mtu = 1500,
 *             PeerASN = 65047,
 *             PrimaryIpv4Prefix = "10.1.1.0/30",
 *             PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a0/126",
 *             SecondaryIpv4Prefix = "10.1.1.4/30",
 *             SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::a4/126",
 *             VlanId = 1001,
 *         },
 *         OptionBProperties = new AzureNative.ManagedNetworkFabric.Inputs.OptionBPropertiesArgs
 *         {
 *             ExportRouteTargets = new[]
 *             {
 *                 "65046:10039",
 *             },
 *             ImportRouteTargets = new[]
 *             {
 *                 "65046:10039",
 *             },
 *         },
 *         PeeringOption = AzureNative.ManagedNetworkFabric.PeeringOption.OptionA,
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewExternalNetwork(ctx, "externalNetwork", &managednetworkfabric.ExternalNetworkArgs{
 * 			ExportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName"),
 * 			ExternalNetworkName:   pulumi.String("example-externalnetwork"),
 * 			ImportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName"),
 * 			L3IsolationDomainName: pulumi.String("example-l3domain"),
 * 			OptionAProperties: &managednetworkfabric.ExternalNetworkPropertiesOptionAPropertiesArgs{
 * 				Mtu:                 pulumi.Int(1500),
 * 				PeerASN:             pulumi.Int(65047),
 * 				PrimaryIpv4Prefix:   pulumi.String("10.1.1.0/30"),
 * 				PrimaryIpv6Prefix:   pulumi.String("3FFE:FFFF:0:CD30::a0/126"),
 * 				SecondaryIpv4Prefix: pulumi.String("10.1.1.4/30"),
 * 				SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a4/126"),
 * 				VlanId:              pulumi.Int(1001),
 * 			},
 * 			OptionBProperties: &managednetworkfabric.OptionBPropertiesArgs{
 * 				ExportRouteTargets: pulumi.StringArray{
 * 					pulumi.String("65046:10039"),
 * 				},
 * 				ImportRouteTargets: pulumi.StringArray{
 * 					pulumi.String("65046:10039"),
 * 				},
 * 			},
 * 			PeeringOption:     pulumi.String(managednetworkfabric.PeeringOptionOptionA),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.ExternalNetwork;
 * import com.pulumi.azurenative.managednetworkfabric.ExternalNetworkArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.ExternalNetworkPropertiesOptionAPropertiesArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.OptionBPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var externalNetwork = new ExternalNetwork("externalNetwork", ExternalNetworkArgs.builder()
 *             .exportRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName")
 *             .externalNetworkName("example-externalnetwork")
 *             .importRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName")
 *             .l3IsolationDomainName("example-l3domain")
 *             .optionAProperties(ExternalNetworkPropertiesOptionAPropertiesArgs.builder()
 *                 .mtu(1500)
 *                 .peerASN(65047)
 *                 .primaryIpv4Prefix("10.1.1.0/30")
 *                 .primaryIpv6Prefix("3FFE:FFFF:0:CD30::a0/126")
 *                 .secondaryIpv4Prefix("10.1.1.4/30")
 *                 .secondaryIpv6Prefix("3FFE:FFFF:0:CD30::a4/126")
 *                 .vlanId(1001)
 *                 .build())
 *             .optionBProperties(OptionBPropertiesArgs.builder()
 *                 .exportRouteTargets("65046:10039")
 *                 .importRouteTargets("65046:10039")
 *                 .build())
 *             .peeringOption("OptionA")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:ExternalNetwork example-externalnetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/{l3IsolationDomainName}/externalNetworks/{externalNetworkName}
 * ```
 */
public class ExternalNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.ExternalNetwork,
) : KotlinCustomResource(javaResource, ExternalNetworkMapper) {
    /**
     * AdministrativeState of the externalNetwork. Example: Enabled | Disabled.
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of resources the externalNetwork is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val disabledOnResources: Output<List<String>>
        get() = javaResource.disabledOnResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARM resource ID of exportRoutePolicy.
     */
    public val exportRoutePolicyId: Output<String>?
        get() = javaResource.exportRoutePolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM resource ID of importRoutePolicy.
     */
    public val importRoutePolicyId: Output<String>?
        get() = javaResource.importRoutePolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the networkToNetworkInterconnectId of the resource.
     */
    public val networkToNetworkInterconnectId: Output<String>
        get() = javaResource.networkToNetworkInterconnectId().applyValue({ args0 -> args0 })

    /**
     * option A properties object
     */
    public val optionAProperties: Output<ExternalNetworkPropertiesResponseOptionAProperties>?
        get() = javaResource.optionAProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    externalNetworkPropertiesResponseOptionAPropertiesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * option B properties object
     */
    public val optionBProperties: Output<OptionBPropertiesResponse>?
        get() = javaResource.optionBProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> optionBPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Peering option list.
     */
    public val peeringOption: Output<String>
        get() = javaResource.peeringOption().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExternalNetworkMapper : ResourceMapper<ExternalNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.ExternalNetwork::class == javaResource::class

    override fun map(javaResource: Resource): ExternalNetwork = ExternalNetwork(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.ExternalNetwork,
    )
}

/**
 * @see [ExternalNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExternalNetwork].
 */
public suspend fun externalNetwork(
    name: String,
    block: suspend ExternalNetworkResourceBuilder.() -> Unit,
): ExternalNetwork {
    val builder = ExternalNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExternalNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun externalNetwork(name: String): ExternalNetwork {
    val builder = ExternalNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
