@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.InternetGatewayRuleArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.RulePropertiesArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.RulePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Internet Gateway Rule resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### InternetGatewayRules_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var internetGatewayRule = new AzureNative.ManagedNetworkFabric.InternetGatewayRule("internetGatewayRule", new()
 *     {
 *         Annotation = "annotationValue",
 *         InternetGatewayRuleName = "example-internetGatewayRule",
 *         Location = "eastus",
 *         ResourceGroupName = "example-rg",
 *         RuleProperties = new AzureNative.ManagedNetworkFabric.Inputs.RulePropertiesArgs
 *         {
 *             Action = AzureNative.ManagedNetworkFabric.Action.Allow,
 *             AddressList = new[]
 *             {
 *                 "10.10.10.10",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "keyID", "keyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewInternetGatewayRule(ctx, "internetGatewayRule", &managednetworkfabric.InternetGatewayRuleArgs{
 * 			Annotation:              pulumi.String("annotationValue"),
 * 			InternetGatewayRuleName: pulumi.String("example-internetGatewayRule"),
 * 			Location:                pulumi.String("eastus"),
 * 			ResourceGroupName:       pulumi.String("example-rg"),
 * 			RuleProperties: &managednetworkfabric.RulePropertiesArgs{
 * 				Action: pulumi.String(managednetworkfabric.ActionAllow),
 * 				AddressList: pulumi.StringArray{
 * 					pulumi.String("10.10.10.10"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"keyID": pulumi.String("keyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.InternetGatewayRule;
 * import com.pulumi.azurenative.managednetworkfabric.InternetGatewayRuleArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.RulePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var internetGatewayRule = new InternetGatewayRule("internetGatewayRule", InternetGatewayRuleArgs.builder()
 *             .annotation("annotationValue")
 *             .internetGatewayRuleName("example-internetGatewayRule")
 *             .location("eastus")
 *             .resourceGroupName("example-rg")
 *             .ruleProperties(RulePropertiesArgs.builder()
 *                 .action("Allow")
 *                 .addressList("10.10.10.10")
 *                 .build())
 *             .tags(Map.of("keyID", "keyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:InternetGatewayRule example-internetGatewayRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/internetGatewayRules/{internetGatewayRuleName}
 * ```
 * @property annotation Switch configuration description.
 * @property internetGatewayRuleName Name of the Internet Gateway rule.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleProperties Rules for the InternetGateways
 * @property tags Resource tags.
 */
public data class InternetGatewayRuleArgs(
    public val `annotation`: Output<String>? = null,
    public val internetGatewayRuleName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleProperties: Output<RulePropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.InternetGatewayRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.InternetGatewayRuleArgs =
        com.pulumi.azurenative.managednetworkfabric.InternetGatewayRuleArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .internetGatewayRuleName(internetGatewayRuleName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleProperties(ruleProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InternetGatewayRuleArgs].
 */
@PulumiTagMarker
public class InternetGatewayRuleArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var internetGatewayRuleName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleProperties: Output<RulePropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("mrxbqkqatcpwdyqs")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Name of the Internet Gateway rule.
     */
    @JvmName("sewmgcbmdqfpiefp")
    public suspend fun internetGatewayRuleName(`value`: Output<String>) {
        this.internetGatewayRuleName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ohmldswlelhrdfgy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xpnjvhdvmtxirbio")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Rules for the InternetGateways
     */
    @JvmName("qliiccbkwtdlyqld")
    public suspend fun ruleProperties(`value`: Output<RulePropertiesArgs>) {
        this.ruleProperties = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("meycrccydqxcskqp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("xcrjxdnginplfsrd")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Name of the Internet Gateway rule.
     */
    @JvmName("tkpuefacjfxlwepm")
    public suspend fun internetGatewayRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetGatewayRuleName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wdkjoywatmsvsfdv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xcqjmigwcuqjfksb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Rules for the InternetGateways
     */
    @JvmName("vbdxlnxpmklhdawq")
    public suspend fun ruleProperties(`value`: RulePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleProperties = mapped
    }

    /**
     * @param argument Rules for the InternetGateways
     */
    @JvmName("uxippymbceglwbvr")
    public suspend fun ruleProperties(argument: suspend RulePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RulePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ruleProperties = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("begncjrbntmvmugv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ieavataxvhdhhftc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InternetGatewayRuleArgs = InternetGatewayRuleArgs(
        `annotation` = `annotation`,
        internetGatewayRuleName = internetGatewayRuleName,
        location = location,
        resourceGroupName = resourceGroupName,
        ruleProperties = ruleProperties,
        tags = tags,
    )
}
