@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IpExtendedCommunity].
 */
@PulumiTagMarker
public class IpExtendedCommunityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpExtendedCommunityArgs = IpExtendedCommunityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpExtendedCommunityArgsBuilder.() -> Unit) {
        val builder = IpExtendedCommunityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpExtendedCommunity {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunity(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IpExtendedCommunity(builtJavaResource)
    }
}

/**
 * The IpExtendedCommunity resource definition.
 * Azure REST API version: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### IpExtendedCommunities_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipExtendedCommunity = new AzureNative.ManagedNetworkFabric.IpExtendedCommunity("ipExtendedCommunity", new()
 *     {
 *         Action = AzureNative.ManagedNetworkFabric.CommunityActionTypes.Permit,
 *         Annotation = "annotationValue",
 *         IpExtendedCommunityName = "example_ipExtendedCommunity",
 *         Location = "EastUs",
 *         ResourceGroupName = "rgIpExtendedCommunityLists",
 *         RouteTargets = new[]
 *         {
 *             "1234:5678",
 *         },
 *         Tags =
 *         {
 *             { "key5054", "key" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewIpExtendedCommunity(ctx, "ipExtendedCommunity", &managednetworkfabric.IpExtendedCommunityArgs{
 * 			Action:                  pulumi.String(managednetworkfabric.CommunityActionTypesPermit),
 * 			Annotation:              pulumi.String("annotationValue"),
 * 			IpExtendedCommunityName: pulumi.String("example_ipExtendedCommunity"),
 * 			Location:                pulumi.String("EastUs"),
 * 			ResourceGroupName:       pulumi.String("rgIpExtendedCommunityLists"),
 * 			RouteTargets: pulumi.StringArray{
 * 				pulumi.String("1234:5678"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key5054": pulumi.String("key"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunity;
 * import com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipExtendedCommunity = new IpExtendedCommunity("ipExtendedCommunity", IpExtendedCommunityArgs.builder()
 *             .action("Permit")
 *             .annotation("annotationValue")
 *             .ipExtendedCommunityName("example_ipExtendedCommunity")
 *             .location("EastUs")
 *             .resourceGroupName("rgIpExtendedCommunityLists")
 *             .routeTargets("1234:5678")
 *             .tags(Map.of("key5054", "key"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:IpExtendedCommunity example_ipExtendedCommunity /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}
 * ```
 */
public class IpExtendedCommunity internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunity,
) : KotlinCustomResource(javaResource, IpExtendedCommunityMapper) {
    /**
     * Action to be taken on the configuration. Example: Permit | Deny.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in range of 0-4294967295.
     */
    public val routeTargets: Output<List<String>>
        get() = javaResource.routeTargets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IpExtendedCommunityMapper : ResourceMapper<IpExtendedCommunity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunity::class == javaResource::class

    override fun map(javaResource: Resource): IpExtendedCommunity = IpExtendedCommunity(
        javaResource
            as com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunity,
    )
}

/**
 * @see [IpExtendedCommunity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpExtendedCommunity].
 */
public suspend fun ipExtendedCommunity(
    name: String,
    block: suspend IpExtendedCommunityResourceBuilder.() -> Unit,
): IpExtendedCommunity {
    val builder = IpExtendedCommunityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpExtendedCommunity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipExtendedCommunity(name: String): IpExtendedCommunity {
    val builder = IpExtendedCommunityResourceBuilder()
    builder.name(name)
    return builder.build()
}
