@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [L2IsolationDomain].
 */
@PulumiTagMarker
public class L2IsolationDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: L2IsolationDomainArgs = L2IsolationDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend L2IsolationDomainArgsBuilder.() -> Unit) {
        val builder = L2IsolationDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): L2IsolationDomain {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.L2IsolationDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return L2IsolationDomain(builtJavaResource)
    }
}

/**
 * The L2IsolationDomain resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### L2IsolationDomains_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l2IsolationDomain = new AzureNative.ManagedNetworkFabric.L2IsolationDomain("l2IsolationDomain", new()
 *     {
 *         L2IsolationDomainName = "example-l2domain",
 *         Location = "eastus",
 *         Mtu = 1500,
 *         NetworkFabricId = "/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName",
 *         ResourceGroupName = "resourceGroupName",
 *         VlanId = 501,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewL2IsolationDomain(ctx, "l2IsolationDomain", &managednetworkfabric.L2IsolationDomainArgs{
 * 			L2IsolationDomainName: pulumi.String("example-l2domain"),
 * 			Location:              pulumi.String("eastus"),
 * 			Mtu:                   pulumi.Int(1500),
 * 			NetworkFabricId:       pulumi.String("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName"),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			VlanId:                pulumi.Int(501),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.L2IsolationDomain;
 * import com.pulumi.azurenative.managednetworkfabric.L2IsolationDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l2IsolationDomain = new L2IsolationDomain("l2IsolationDomain", L2IsolationDomainArgs.builder()
 *             .l2IsolationDomainName("example-l2domain")
 *             .location("eastus")
 *             .mtu(1500)
 *             .networkFabricId("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName")
 *             .resourceGroupName("resourceGroupName")
 *             .vlanId(501)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:L2IsolationDomain wcpalyqmig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/{l2IsolationDomainName}
 * ```
 */
public class L2IsolationDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.L2IsolationDomain,
) : KotlinCustomResource(javaResource, L2IsolationDomainMapper) {
    /**
     * state. Example: Enabled | Disabled. It indicates administrative state of the isolationDomain, whether it is enabled or disabled. If enabled, the configuration is applied on the devices. If disabled, the configuration is removed from the devices
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of resources the L2 Isolation Domain is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val disabledOnResources: Output<List<String>>
        get() = javaResource.disabledOnResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * maximum transmission unit. Default value is 1500.
     */
    public val mtu: Output<Int>?
        get() = javaResource.mtu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network Fabric ARM resource id.
     */
    public val networkFabricId: Output<String>
        get() = javaResource.networkFabricId().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * vlanId. Example: 501.
     */
    public val vlanId: Output<Int>
        get() = javaResource.vlanId().applyValue({ args0 -> args0 })
}

public object L2IsolationDomainMapper : ResourceMapper<L2IsolationDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.L2IsolationDomain::class == javaResource::class

    override fun map(javaResource: Resource): L2IsolationDomain = L2IsolationDomain(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.L2IsolationDomain,
    )
}

/**
 * @see [L2IsolationDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [L2IsolationDomain].
 */
public suspend fun l2IsolationDomain(
    name: String,
    block: suspend L2IsolationDomainResourceBuilder.() -> Unit,
): L2IsolationDomain {
    val builder = L2IsolationDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [L2IsolationDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun l2IsolationDomain(name: String): L2IsolationDomain {
    val builder = L2IsolationDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
