@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NeighborGroupDestinationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NeighborGroupDestinationResponse.Companion.toKotlin as neighborGroupDestinationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NeighborGroup].
 */
@PulumiTagMarker
public class NeighborGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NeighborGroupArgs = NeighborGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NeighborGroupArgsBuilder.() -> Unit) {
        val builder = NeighborGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NeighborGroup {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NeighborGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NeighborGroup(builtJavaResource)
    }
}

/**
 * Defines the Neighbor Group.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### NeighborGroups_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var neighborGroup = new AzureNative.ManagedNetworkFabric.NeighborGroup("neighborGroup", new()
 *     {
 *         Annotation = "annotation",
 *         Destination = new AzureNative.ManagedNetworkFabric.Inputs.NeighborGroupDestinationArgs
 *         {
 *             Ipv4Addresses = new[]
 *             {
 *                 "10.10.10.10",
 *                 "20.10.10.10",
 *                 "30.10.10.10",
 *                 "40.10.10.10",
 *                 "50.10.10.10",
 *                 "60.10.10.10",
 *                 "70.10.10.10",
 *                 "80.10.10.10",
 *                 "90.10.10.10",
 *             },
 *             Ipv6Addresses = new[]
 *             {
 *                 "2F::/100",
 *             },
 *         },
 *         Location = "eastus",
 *         NeighborGroupName = "example-neighborGroup",
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "key8107", "1234" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNeighborGroup(ctx, "neighborGroup", &managednetworkfabric.NeighborGroupArgs{
 * 			Annotation: pulumi.String("annotation"),
 * 			Destination: &managednetworkfabric.NeighborGroupDestinationArgs{
 * 				Ipv4Addresses: pulumi.StringArray{
 * 					pulumi.String("10.10.10.10"),
 * 					pulumi.String("20.10.10.10"),
 * 					pulumi.String("30.10.10.10"),
 * 					pulumi.String("40.10.10.10"),
 * 					pulumi.String("50.10.10.10"),
 * 					pulumi.String("60.10.10.10"),
 * 					pulumi.String("70.10.10.10"),
 * 					pulumi.String("80.10.10.10"),
 * 					pulumi.String("90.10.10.10"),
 * 				},
 * 				Ipv6Addresses: pulumi.StringArray{
 * 					pulumi.String("2F::/100"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			NeighborGroupName: pulumi.String("example-neighborGroup"),
 * 			ResourceGroupName: pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key8107": pulumi.String("1234"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NeighborGroup;
 * import com.pulumi.azurenative.managednetworkfabric.NeighborGroupArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.NeighborGroupDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var neighborGroup = new NeighborGroup("neighborGroup", NeighborGroupArgs.builder()
 *             .annotation("annotation")
 *             .destination(NeighborGroupDestinationArgs.builder()
 *                 .ipv4Addresses(
 *                     "10.10.10.10",
 *                     "20.10.10.10",
 *                     "30.10.10.10",
 *                     "40.10.10.10",
 *                     "50.10.10.10",
 *                     "60.10.10.10",
 *                     "70.10.10.10",
 *                     "80.10.10.10",
 *                     "90.10.10.10")
 *                 .ipv6Addresses("2F::/100")
 *                 .build())
 *             .location("eastus")
 *             .neighborGroupName("example-neighborGroup")
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("key8107", "1234"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NeighborGroup example-neighborGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/neighborGroups/{neighborGroupName}
 * ```
 */
public class NeighborGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NeighborGroup,
) : KotlinCustomResource(javaResource, NeighborGroupMapper) {
    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array of destination IPv4 Addresses or IPv6 Addresses.
     */
    public val destination: Output<NeighborGroupDestinationResponse>
        get() = javaResource.destination().applyValue({ args0 ->
            args0.let({ args0 ->
                neighborGroupDestinationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of NetworkTap IDs where neighbor group is associated.
     */
    public val networkTapIds: Output<List<String>>
        get() = javaResource.networkTapIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of Network Tap Rule IDs where neighbor group is associated.
     */
    public val networkTapRuleIds: Output<List<String>>
        get() = javaResource.networkTapRuleIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NeighborGroupMapper : ResourceMapper<NeighborGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NeighborGroup::class == javaResource::class

    override fun map(javaResource: Resource): NeighborGroup = NeighborGroup(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.NeighborGroup,
    )
}

/**
 * @see [NeighborGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NeighborGroup].
 */
public suspend fun neighborGroup(
    name: String,
    block: suspend NeighborGroupResourceBuilder.() -> Unit,
): NeighborGroup {
    val builder = NeighborGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NeighborGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun neighborGroup(name: String): NeighborGroup {
    val builder = NeighborGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
