@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkDeviceArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.NetworkDeviceRoleTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The NetworkDevice resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkDevices_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkDevice = new AzureNative.ManagedNetworkFabric.NetworkDevice("networkDevice", new()
 *     {
 *         Annotation = "null",
 *         HostName = "networkDeviceName",
 *         Location = "eastus",
 *         NetworkDeviceName = "networkDeviceName",
 *         NetworkDeviceRole = AzureNative.ManagedNetworkFabric.NetworkDeviceRoleTypes.CE,
 *         NetworkDeviceSku = "DefaultSku",
 *         ResourceGroupName = "resourceGroupName",
 *         SerialNumber = "Arista;DCS-7280PR3-24;12.05;JPE21330382",
 *         Tags =
 *         {
 *             { "keyID", "keyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkDevice(ctx, "networkDevice", &managednetworkfabric.NetworkDeviceArgs{
 * 			Annotation:        pulumi.String("null"),
 * 			HostName:          pulumi.String("networkDeviceName"),
 * 			Location:          pulumi.String("eastus"),
 * 			NetworkDeviceName: pulumi.String("networkDeviceName"),
 * 			NetworkDeviceRole: pulumi.String(managednetworkfabric.NetworkDeviceRoleTypesCE),
 * 			NetworkDeviceSku:  pulumi.String("DefaultSku"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SerialNumber:      pulumi.String("Arista;DCS-7280PR3-24;12.05;JPE21330382"),
 * 			Tags: pulumi.StringMap{
 * 				"keyID": pulumi.String("keyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkDevice;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkDevice = new NetworkDevice("networkDevice", NetworkDeviceArgs.builder()
 *             .annotation("null")
 *             .hostName("networkDeviceName")
 *             .location("eastus")
 *             .networkDeviceName("networkDeviceName")
 *             .networkDeviceRole("CE")
 *             .networkDeviceSku("DefaultSku")
 *             .resourceGroupName("resourceGroupName")
 *             .serialNumber("Arista;DCS-7280PR3-24;12.05;JPE21330382")
 *             .tags(Map.of("keyID", "keyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkDevice networkDeviceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkDevices/{networkDeviceName}
 * ```
 * @property annotation Switch configuration description.
 * @property hostName The host Name of the device.
 * @property location The geo-location where the resource lives
 * @property networkDeviceName Name of the Network Device
 * @property networkDeviceRole networkDeviceRole is the device role: Example: CE | ToR.
 * @property networkDeviceSku Network Device SKU name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serialNumber serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber. Example: Arista;DCS-7280DR3-24;12.05;JPE21116969
 * @property tags Resource tags.
 */
public data class NetworkDeviceArgs(
    public val `annotation`: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkDeviceName: Output<String>? = null,
    public val networkDeviceRole: Output<Either<String, NetworkDeviceRoleTypes>>? = null,
    public val networkDeviceSku: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkDeviceArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NetworkDeviceArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkDeviceArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkDeviceName(networkDeviceName?.applyValue({ args0 -> args0 }))
            .networkDeviceRole(
                networkDeviceRole?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkDeviceSku(networkDeviceSku?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkDeviceArgs].
 */
@PulumiTagMarker
public class NetworkDeviceArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var hostName: Output<String>? = null

    private var location: Output<String>? = null

    private var networkDeviceName: Output<String>? = null

    private var networkDeviceRole: Output<Either<String, NetworkDeviceRoleTypes>>? = null

    private var networkDeviceSku: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("sjqrgiwrmcokxtkk")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value The host Name of the device.
     */
    @JvmName("ltqkqqwoxxikbwog")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ekxnberxmkwybdmp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Network Device
     */
    @JvmName("xcgxprqxoruoyaey")
    public suspend fun networkDeviceName(`value`: Output<String>) {
        this.networkDeviceName = value
    }

    /**
     * @param value networkDeviceRole is the device role: Example: CE | ToR.
     */
    @JvmName("ntlqxvvptydtntlr")
    public suspend fun networkDeviceRole(`value`: Output<Either<String, NetworkDeviceRoleTypes>>) {
        this.networkDeviceRole = value
    }

    /**
     * @param value Network Device SKU name.
     */
    @JvmName("njvpjwdpguxnyuxa")
    public suspend fun networkDeviceSku(`value`: Output<String>) {
        this.networkDeviceSku = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qnfslsqmpetjnhnj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber. Example: Arista;DCS-7280DR3-24;12.05;JPE21116969
     */
    @JvmName("qeyvpsqdgxflspfp")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lptmxyjkqrewvmon")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("rxcbhhcxjjsdxnnu")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value The host Name of the device.
     */
    @JvmName("emkdloikqtigiqhv")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sodokkvpocqedalu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Network Device
     */
    @JvmName("ogbhangthqrqcetr")
    public suspend fun networkDeviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDeviceName = mapped
    }

    /**
     * @param value networkDeviceRole is the device role: Example: CE | ToR.
     */
    @JvmName("ueppdgasdjireesj")
    public suspend fun networkDeviceRole(`value`: Either<String, NetworkDeviceRoleTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDeviceRole = mapped
    }

    /**
     * @param value networkDeviceRole is the device role: Example: CE | ToR.
     */
    @JvmName("pkqxpqfedtfesivc")
    public fun networkDeviceRole(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkDeviceRoleTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDeviceRole = mapped
    }

    /**
     * @param value networkDeviceRole is the device role: Example: CE | ToR.
     */
    @JvmName("wruxwexcgjiqshjs")
    public fun networkDeviceRole(`value`: NetworkDeviceRoleTypes) {
        val toBeMapped = Either.ofRight<String, NetworkDeviceRoleTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDeviceRole = mapped
    }

    /**
     * @param value Network Device SKU name.
     */
    @JvmName("rtranvvmlcujssxs")
    public suspend fun networkDeviceSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDeviceSku = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lgbggpbfatokqaqj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber. Example: Arista;DCS-7280DR3-24;12.05;JPE21116969
     */
    @JvmName("finwwtcsxukvrulb")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dhmfqbkscufemarq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("warlyhxdqkqtuuea")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkDeviceArgs = NetworkDeviceArgs(
        `annotation` = `annotation`,
        hostName = hostName,
        location = location,
        networkDeviceName = networkDeviceName,
        networkDeviceRole = networkDeviceRole,
        networkDeviceSku = networkDeviceSku,
        resourceGroupName = resourceGroupName,
        serialNumber = serialNumber,
        tags = tags,
    )
}
