@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapPropertiesResponseDestinations
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapPropertiesResponseDestinations.Companion.toKotlin as networkTapPropertiesResponseDestinationsToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkTap].
 */
@PulumiTagMarker
public class NetworkTapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkTapArgs = NetworkTapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkTapArgsBuilder.() -> Unit) {
        val builder = NetworkTapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkTap {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkTap(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkTap(builtJavaResource)
    }
}

/**
 * The Network Tap resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### NetworkTaps_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkTap = new AzureNative.ManagedNetworkFabric.NetworkTap("networkTap", new()
 *     {
 *         Annotation = "annotation",
 *         Destinations = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.NetworkTapPropertiesDestinationsArgs
 *             {
 *                 DestinationId = "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/l3IsloationDomains/example-l3Domain/internalNetworks/example-internalNetwork",
 *                 DestinationTapRuleId = "/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkTapRules/example-destinationTapRule",
 *                 DestinationType = AzureNative.ManagedNetworkFabric.DestinationType.IsolationDomain,
 *                 IsolationDomainProperties = new AzureNative.ManagedNetworkFabric.Inputs.IsolationDomainPropertiesArgs
 *                 {
 *                     Encapsulation = AzureNative.ManagedNetworkFabric.Encapsulation.None,
 *                     NeighborGroupIds = new[]
 *                     {
 *                         "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup",
 *                     },
 *                 },
 *                 Name = "example-destinaionName",
 *             },
 *         },
 *         Location = "eastuseuap",
 *         NetworkPacketBrokerId = "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/example-networkPacketBroker",
 *         NetworkTapName = "example-networkTap",
 *         PollingType = AzureNative.ManagedNetworkFabric.PollingType.Pull,
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "key6024", "1234" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkTap(ctx, "networkTap", &managednetworkfabric.NetworkTapArgs{
 * 			Annotation: pulumi.String("annotation"),
 * 			Destinations: managednetworkfabric.NetworkTapPropertiesDestinationsArray{
 * 				&managednetworkfabric.NetworkTapPropertiesDestinationsArgs{
 * 					DestinationId:        pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/l3IsloationDomains/example-l3Domain/internalNetworks/example-internalNetwork"),
 * 					DestinationTapRuleId: pulumi.String("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkTapRules/example-destinationTapRule"),
 * 					DestinationType:      pulumi.String(managednetworkfabric.DestinationTypeIsolationDomain),
 * 					IsolationDomainProperties: &managednetworkfabric.IsolationDomainPropertiesArgs{
 * 						Encapsulation: pulumi.String(managednetworkfabric.EncapsulationNone),
 * 						NeighborGroupIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup"),
 * 						},
 * 					},
 * 					Name: pulumi.String("example-destinaionName"),
 * 				},
 * 			},
 * 			Location:              pulumi.String("eastuseuap"),
 * 			NetworkPacketBrokerId: pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/example-networkPacketBroker"),
 * 			NetworkTapName:        pulumi.String("example-networkTap"),
 * 			PollingType:           pulumi.String(managednetworkfabric.PollingTypePull),
 * 			ResourceGroupName:     pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key6024": pulumi.String("1234"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkTap;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkTapArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapPropertiesDestinationsArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.IsolationDomainPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkTap = new NetworkTap("networkTap", NetworkTapArgs.builder()
 *             .annotation("annotation")
 *             .destinations(NetworkTapPropertiesDestinationsArgs.builder()
 *                 .destinationId("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/l3IsloationDomains/example-l3Domain/internalNetworks/example-internalNetwork")
 *                 .destinationTapRuleId("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkTapRules/example-destinationTapRule")
 *                 .destinationType("IsolationDomain")
 *                 .isolationDomainProperties(IsolationDomainPropertiesArgs.builder()
 *                     .encapsulation("None")
 *                     .neighborGroupIds("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup")
 *                     .build())
 *                 .name("example-destinaionName")
 *                 .build())
 *             .location("eastuseuap")
 *             .networkPacketBrokerId("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/example-networkPacketBroker")
 *             .networkTapName("example-networkTap")
 *             .pollingType("Pull")
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("key6024", "1234"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkTap example-networkTap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkTaps/{networkTapName}
 * ```
 */
public class NetworkTap internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkTap,
) : KotlinCustomResource(javaResource, NetworkTapMapper) {
    /**
     * Administrative state of the resource. Example -Enabled/Disabled
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the configurations state of the resource.
     */
    public val configurationState: Output<String>
        get() = javaResource.configurationState().applyValue({ args0 -> args0 })

    /**
     * List of destinations to send the filter traffic.
     */
    public val destinations: Output<List<NetworkTapPropertiesResponseDestinations>>
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkTapPropertiesResponseDestinationsToKotlin(args0)
                })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARM resource ID of the Network Packet Broker.
     */
    public val networkPacketBrokerId: Output<String>
        get() = javaResource.networkPacketBrokerId().applyValue({ args0 -> args0 })

    /**
     * Polling type.
     */
    public val pollingType: Output<String>?
        get() = javaResource.pollingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on the status of Network Tap provisioning.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Source Tap Rule Id. ARM Resource ID of the Network Tap Rule.
     */
    public val sourceTapRuleId: Output<String>
        get() = javaResource.sourceTapRuleId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkTapMapper : ResourceMapper<NetworkTap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkTap::class == javaResource::class

    override fun map(javaResource: Resource): NetworkTap = NetworkTap(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.NetworkTap,
    )
}

/**
 * @see [NetworkTap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkTap].
 */
public suspend fun networkTap(name: String, block: suspend NetworkTapResourceBuilder.() -> Unit): NetworkTap {
    val builder = NetworkTapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkTap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkTap(name: String): NetworkTap {
    val builder = NetworkTapResourceBuilder()
    builder.name(name)
    return builder.build()
}
