@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkTapArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.PollingType
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.NetworkTapPropertiesDestinationsArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.NetworkTapPropertiesDestinationsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Network Tap resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### NetworkTaps_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkTap = new AzureNative.ManagedNetworkFabric.NetworkTap("networkTap", new()
 *     {
 *         Annotation = "annotation",
 *         Destinations = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.NetworkTapPropertiesDestinationsArgs
 *             {
 *                 DestinationId = "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/l3IsloationDomains/example-l3Domain/internalNetworks/example-internalNetwork",
 *                 DestinationTapRuleId = "/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkTapRules/example-destinationTapRule",
 *                 DestinationType = AzureNative.ManagedNetworkFabric.DestinationType.IsolationDomain,
 *                 IsolationDomainProperties = new AzureNative.ManagedNetworkFabric.Inputs.IsolationDomainPropertiesArgs
 *                 {
 *                     Encapsulation = AzureNative.ManagedNetworkFabric.Encapsulation.None,
 *                     NeighborGroupIds = new[]
 *                     {
 *                         "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup",
 *                     },
 *                 },
 *                 Name = "example-destinaionName",
 *             },
 *         },
 *         Location = "eastuseuap",
 *         NetworkPacketBrokerId = "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/example-networkPacketBroker",
 *         NetworkTapName = "example-networkTap",
 *         PollingType = AzureNative.ManagedNetworkFabric.PollingType.Pull,
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "key6024", "1234" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkTap(ctx, "networkTap", &managednetworkfabric.NetworkTapArgs{
 * 			Annotation: pulumi.String("annotation"),
 * 			Destinations: managednetworkfabric.NetworkTapPropertiesDestinationsArray{
 * 				&managednetworkfabric.NetworkTapPropertiesDestinationsArgs{
 * 					DestinationId:        pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/l3IsloationDomains/example-l3Domain/internalNetworks/example-internalNetwork"),
 * 					DestinationTapRuleId: pulumi.String("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkTapRules/example-destinationTapRule"),
 * 					DestinationType:      pulumi.String(managednetworkfabric.DestinationTypeIsolationDomain),
 * 					IsolationDomainProperties: &managednetworkfabric.IsolationDomainPropertiesArgs{
 * 						Encapsulation: pulumi.String(managednetworkfabric.EncapsulationNone),
 * 						NeighborGroupIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup"),
 * 						},
 * 					},
 * 					Name: pulumi.String("example-destinaionName"),
 * 				},
 * 			},
 * 			Location:              pulumi.String("eastuseuap"),
 * 			NetworkPacketBrokerId: pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/example-networkPacketBroker"),
 * 			NetworkTapName:        pulumi.String("example-networkTap"),
 * 			PollingType:           pulumi.String(managednetworkfabric.PollingTypePull),
 * 			ResourceGroupName:     pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key6024": pulumi.String("1234"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkTap;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkTapArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapPropertiesDestinationsArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.IsolationDomainPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkTap = new NetworkTap("networkTap", NetworkTapArgs.builder()
 *             .annotation("annotation")
 *             .destinations(NetworkTapPropertiesDestinationsArgs.builder()
 *                 .destinationId("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/l3IsloationDomains/example-l3Domain/internalNetworks/example-internalNetwork")
 *                 .destinationTapRuleId("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkTapRules/example-destinationTapRule")
 *                 .destinationType("IsolationDomain")
 *                 .isolationDomainProperties(IsolationDomainPropertiesArgs.builder()
 *                     .encapsulation("None")
 *                     .neighborGroupIds("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup")
 *                     .build())
 *                 .name("example-destinaionName")
 *                 .build())
 *             .location("eastuseuap")
 *             .networkPacketBrokerId("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/example-networkPacketBroker")
 *             .networkTapName("example-networkTap")
 *             .pollingType("Pull")
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("key6024", "1234"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkTap example-networkTap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkTaps/{networkTapName}
 * ```
 * @property annotation Switch configuration description.
 * @property destinations List of destinations to send the filter traffic.
 * @property location The geo-location where the resource lives
 * @property networkPacketBrokerId ARM resource ID of the Network Packet Broker.
 * @property networkTapName Name of the Network Tap.
 * @property pollingType Polling type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkTapArgs(
    public val `annotation`: Output<String>? = null,
    public val destinations: Output<List<NetworkTapPropertiesDestinationsArgs>>? = null,
    public val location: Output<String>? = null,
    public val networkPacketBrokerId: Output<String>? = null,
    public val networkTapName: Output<String>? = null,
    public val pollingType: Output<Either<String, PollingType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkTapArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NetworkTapArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkTapArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .networkPacketBrokerId(networkPacketBrokerId?.applyValue({ args0 -> args0 }))
            .networkTapName(networkTapName?.applyValue({ args0 -> args0 }))
            .pollingType(
                pollingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkTapArgs].
 */
@PulumiTagMarker
public class NetworkTapArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var destinations: Output<List<NetworkTapPropertiesDestinationsArgs>>? = null

    private var location: Output<String>? = null

    private var networkPacketBrokerId: Output<String>? = null

    private var networkTapName: Output<String>? = null

    private var pollingType: Output<Either<String, PollingType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("yhlxrqrqvugemogv")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value List of destinations to send the filter traffic.
     */
    @JvmName("uqlvhaujhgtysbnl")
    public suspend fun destinations(`value`: Output<List<NetworkTapPropertiesDestinationsArgs>>) {
        this.destinations = value
    }

    @JvmName("ekiksmkxtkbrbpmn")
    public suspend fun destinations(vararg values: Output<NetworkTapPropertiesDestinationsArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values List of destinations to send the filter traffic.
     */
    @JvmName("luslrwfkoxvdumjy")
    public suspend fun destinations(values: List<Output<NetworkTapPropertiesDestinationsArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hsppvhspypfeeepv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ARM resource ID of the Network Packet Broker.
     */
    @JvmName("mcbbclqbnbvuqqhy")
    public suspend fun networkPacketBrokerId(`value`: Output<String>) {
        this.networkPacketBrokerId = value
    }

    /**
     * @param value Name of the Network Tap.
     */
    @JvmName("dulnxliujjvdwnfj")
    public suspend fun networkTapName(`value`: Output<String>) {
        this.networkTapName = value
    }

    /**
     * @param value Polling type.
     */
    @JvmName("dimgndhgkrpwdggr")
    public suspend fun pollingType(`value`: Output<Either<String, PollingType>>) {
        this.pollingType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("upghixesmcsdxrjj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vddbbgrggowlrapg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("bbdvfdkajbuarehx")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value List of destinations to send the filter traffic.
     */
    @JvmName("rcnaftfneqbnibax")
    public suspend fun destinations(`value`: List<NetworkTapPropertiesDestinationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument List of destinations to send the filter traffic.
     */
    @JvmName("fcfmybxsmtqpmeoc")
    public suspend fun destinations(argument: List<suspend NetworkTapPropertiesDestinationsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkTapPropertiesDestinationsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument List of destinations to send the filter traffic.
     */
    @JvmName("vabiknlwqwtjshgk")
    public suspend fun destinations(vararg argument: suspend NetworkTapPropertiesDestinationsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkTapPropertiesDestinationsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument List of destinations to send the filter traffic.
     */
    @JvmName("yyykaqyhfntmsjfq")
    public suspend fun destinations(argument: suspend NetworkTapPropertiesDestinationsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkTapPropertiesDestinationsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values List of destinations to send the filter traffic.
     */
    @JvmName("oaxpibegalafrmdw")
    public suspend fun destinations(vararg values: NetworkTapPropertiesDestinationsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lkorlrmwfhwubylu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ARM resource ID of the Network Packet Broker.
     */
    @JvmName("wkcngcvsasgsglqo")
    public suspend fun networkPacketBrokerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkPacketBrokerId = mapped
    }

    /**
     * @param value Name of the Network Tap.
     */
    @JvmName("lcropiulruyyfoqu")
    public suspend fun networkTapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkTapName = mapped
    }

    /**
     * @param value Polling type.
     */
    @JvmName("emfrljgfqsxjrwgk")
    public suspend fun pollingType(`value`: Either<String, PollingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollingType = mapped
    }

    /**
     * @param value Polling type.
     */
    @JvmName("wlkelmhixtmhgwom")
    public fun pollingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PollingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pollingType = mapped
    }

    /**
     * @param value Polling type.
     */
    @JvmName("xvgdtcuddeolfklt")
    public fun pollingType(`value`: PollingType) {
        val toBeMapped = Either.ofRight<String, PollingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pollingType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("olmerjtxailvrcga")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ypmcdfttqqhxgudw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mkuoldtqqhbpeows")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkTapArgs = NetworkTapArgs(
        `annotation` = `annotation`,
        destinations = destinations,
        location = location,
        networkPacketBrokerId = networkPacketBrokerId,
        networkTapName = networkTapName,
        pollingType = pollingType,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
