@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.CommonDynamicMatchConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapRuleMatchConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.CommonDynamicMatchConfigurationResponse.Companion.toKotlin as commonDynamicMatchConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NetworkTapRuleMatchConfigurationResponse.Companion.toKotlin as networkTapRuleMatchConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkTapRule].
 */
@PulumiTagMarker
public class NetworkTapRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkTapRuleArgs = NetworkTapRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkTapRuleArgsBuilder.() -> Unit) {
        val builder = NetworkTapRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkTapRule {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkTapRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkTapRule(builtJavaResource)
    }
}

/**
 * The NetworkTapRule resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### NetworkTapRules_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkTapRule = new AzureNative.ManagedNetworkFabric.NetworkTapRule("networkTapRule", new()
 *     {
 *         Annotation = "annotation",
 *         ConfigurationType = AzureNative.ManagedNetworkFabric.ConfigurationType.File,
 *         DynamicMatchConfigurations = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.CommonDynamicMatchConfigurationArgs
 *             {
 *                 IpGroups = new[]
 *                 {
 *                     new AzureNative.ManagedNetworkFabric.Inputs.IpGroupPropertiesArgs
 *                     {
 *                         IpAddressType = AzureNative.ManagedNetworkFabric.IPAddressType.IPv4,
 *                         IpPrefixes = new[]
 *                         {
 *                             "10.10.10.10/30",
 *                         },
 *                         Name = "example-ipGroup1",
 *                     },
 *                 },
 *                 PortGroups = new[]
 *                 {
 *                     new AzureNative.ManagedNetworkFabric.Inputs.PortGroupPropertiesArgs
 *                     {
 *                         Name = "example-portGroup1",
 *                         Ports = new[]
 *                         {
 *                             "100-200",
 *                         },
 *                     },
 *                     new AzureNative.ManagedNetworkFabric.Inputs.PortGroupPropertiesArgs
 *                     {
 *                         Name = "example-portGroup2",
 *                         Ports = new[]
 *                         {
 *                             "900",
 *                             "1000-2000",
 *                         },
 *                     },
 *                 },
 *                 VlanGroups = new[]
 *                 {
 *                     new AzureNative.ManagedNetworkFabric.Inputs.VlanGroupPropertiesArgs
 *                     {
 *                         Name = "exmaple-vlanGroup",
 *                         Vlans = new[]
 *                         {
 *                             "10",
 *                             "100-200",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         MatchConfigurations = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.NetworkTapRuleMatchConfigurationArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     new AzureNative.ManagedNetworkFabric.Inputs.NetworkTapRuleActionArgs
 *                     {
 *                         DestinationId = "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup",
 *                         IsTimestampEnabled = AzureNative.ManagedNetworkFabric.BooleanEnumProperty.True,
 *                         MatchConfigurationName = "match1",
 *                         Truncate = "100",
 *                         Type = AzureNative.ManagedNetworkFabric.TapRuleActionType.Drop,
 *                     },
 *                 },
 *                 IpAddressType = AzureNative.ManagedNetworkFabric.IPAddressType.IPv4,
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.ManagedNetworkFabric.Inputs.NetworkTapRuleMatchConditionArgs
 *                     {
 *                         EncapsulationType = AzureNative.ManagedNetworkFabric.EncapsulationType.None,
 *                         IpCondition = new AzureNative.ManagedNetworkFabric.Inputs.IpMatchConditionArgs
 *                         {
 *                             IpGroupNames = new[]
 *                             {
 *                                 "example-ipGroup",
 *                             },
 *                             IpPrefixValues = new[]
 *                             {
 *                                 "10.10.10.10/20",
 *                             },
 *                             PrefixType = AzureNative.ManagedNetworkFabric.PrefixType.Prefix,
 *                             Type = AzureNative.ManagedNetworkFabric.SourceDestinationType.SourceIP,
 *                         },
 *                         PortCondition = new AzureNative.ManagedNetworkFabric.Inputs.PortConditionArgs
 *                         {
 *                             Layer4Protocol = AzureNative.ManagedNetworkFabric.Layer4Protocol.TCP,
 *                             PortGroupNames = new[]
 *                             {
 *                                 "example-portGroup1",
 *                             },
 *                             PortType = AzureNative.ManagedNetworkFabric.PortType.SourcePort,
 *                             Ports = new[]
 *                             {
 *                                 "100",
 *                             },
 *                         },
 *                         ProtocolTypes = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         VlanMatchCondition = new AzureNative.ManagedNetworkFabric.Inputs.VlanMatchConditionArgs
 *                         {
 *                             InnerVlans = new[]
 *                             {
 *                                 "11-20",
 *                             },
 *                             VlanGroupNames = new[]
 *                             {
 *                                 "exmaple-vlanGroup",
 *                             },
 *                             Vlans = new[]
 *                             {
 *                                 "10",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 MatchConfigurationName = "config1",
 *                 SequenceNumber = 10,
 *             },
 *         },
 *         NetworkTapRuleName = "example-tapRule",
 *         PollingIntervalInSeconds = 30,
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "keyID", "keyValue" },
 *         },
 *         TapRulesUrl = "https://microsoft.com/a",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkTapRule(ctx, "networkTapRule", &managednetworkfabric.NetworkTapRuleArgs{
 * 			Annotation:        pulumi.String("annotation"),
 * 			ConfigurationType: pulumi.String(managednetworkfabric.ConfigurationTypeFile),
 * 			DynamicMatchConfigurations: managednetworkfabric.CommonDynamicMatchConfigurationArray{
 * 				&managednetworkfabric.CommonDynamicMatchConfigurationArgs{
 * 					IpGroups: managednetworkfabric.IpGroupPropertiesArray{
 * 						&managednetworkfabric.IpGroupPropertiesArgs{
 * 							IpAddressType: pulumi.String(managednetworkfabric.IPAddressTypeIPv4),
 * 							IpPrefixes: pulumi.StringArray{
 * 								pulumi.String("10.10.10.10/30"),
 * 							},
 * 							Name: pulumi.String("example-ipGroup1"),
 * 						},
 * 					},
 * 					PortGroups: managednetworkfabric.PortGroupPropertiesArray{
 * 						&managednetworkfabric.PortGroupPropertiesArgs{
 * 							Name: pulumi.String("example-portGroup1"),
 * 							Ports: pulumi.StringArray{
 * 								pulumi.String("100-200"),
 * 							},
 * 						},
 * 						&managednetworkfabric.PortGroupPropertiesArgs{
 * 							Name: pulumi.String("example-portGroup2"),
 * 							Ports: pulumi.StringArray{
 * 								pulumi.String("900"),
 * 								pulumi.String("1000-2000"),
 * 							},
 * 						},
 * 					},
 * 					VlanGroups: managednetworkfabric.VlanGroupPropertiesArray{
 * 						&managednetworkfabric.VlanGroupPropertiesArgs{
 * 							Name: pulumi.String("exmaple-vlanGroup"),
 * 							Vlans: pulumi.StringArray{
 * 								pulumi.String("10"),
 * 								pulumi.String("100-200"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			MatchConfigurations: managednetworkfabric.NetworkTapRuleMatchConfigurationArray{
 * 				&managednetworkfabric.NetworkTapRuleMatchConfigurationArgs{
 * 					Actions: managednetworkfabric.NetworkTapRuleActionArray{
 * 						&managednetworkfabric.NetworkTapRuleActionArgs{
 * 							DestinationId:          pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup"),
 * 							IsTimestampEnabled:     pulumi.String(managednetworkfabric.BooleanEnumPropertyTrue),
 * 							MatchConfigurationName: pulumi.String("match1"),
 * 							Truncate:               pulumi.String("100"),
 * 							Type:                   pulumi.String(managednetworkfabric.TapRuleActionTypeDrop),
 * 						},
 * 					},
 * 					IpAddressType: pulumi.String(managednetworkfabric.IPAddressTypeIPv4),
 * 					MatchConditions: managednetworkfabric.NetworkTapRuleMatchConditionArray{
 * 						&managednetworkfabric.NetworkTapRuleMatchConditionArgs{
 * 							EncapsulationType: pulumi.String(managednetworkfabric.EncapsulationTypeNone),
 * 							IpCondition: &managednetworkfabric.IpMatchConditionArgs{
 * 								IpGroupNames: pulumi.StringArray{
 * 									pulumi.String("example-ipGroup"),
 * 								},
 * 								IpPrefixValues: pulumi.StringArray{
 * 									pulumi.String("10.10.10.10/20"),
 * 								},
 * 								PrefixType: pulumi.String(managednetworkfabric.PrefixTypePrefix),
 * 								Type:       pulumi.String(managednetworkfabric.SourceDestinationTypeSourceIP),
 * 							},
 * 							PortCondition: &managednetworkfabric.PortConditionArgs{
 * 								Layer4Protocol: pulumi.String(managednetworkfabric.Layer4ProtocolTCP),
 * 								PortGroupNames: pulumi.StringArray{
 * 									pulumi.String("example-portGroup1"),
 * 								},
 * 								PortType: pulumi.String(managednetworkfabric.PortTypeSourcePort),
 * 								Ports: pulumi.StringArray{
 * 									pulumi.String("100"),
 * 								},
 * 							},
 * 							ProtocolTypes: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							VlanMatchCondition: &managednetworkfabric.VlanMatchConditionArgs{
 * 								InnerVlans: pulumi.StringArray{
 * 									pulumi.String("11-20"),
 * 								},
 * 								VlanGroupNames: pulumi.StringArray{
 * 									pulumi.String("exmaple-vlanGroup"),
 * 								},
 * 								Vlans: pulumi.StringArray{
 * 									pulumi.String("10"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					MatchConfigurationName: pulumi.String("config1"),
 * 					SequenceNumber:         pulumi.Float64(10),
 * 				},
 * 			},
 * 			NetworkTapRuleName:       pulumi.String("example-tapRule"),
 * 			PollingIntervalInSeconds: pulumi.Int(30),
 * 			ResourceGroupName:        pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"keyID": pulumi.String("keyValue"),
 * 			},
 * 			TapRulesUrl: pulumi.String("https://microsoft.com/a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkTapRule;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkTapRuleArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkTapRule = new NetworkTapRule("networkTapRule", NetworkTapRuleArgs.builder()
 *             .annotation("annotation")
 *             .configurationType("File")
 *             .dynamicMatchConfigurations(CommonDynamicMatchConfigurationArgs.builder()
 *                 .ipGroups(IpGroupPropertiesArgs.builder()
 *                     .ipAddressType("IPv4")
 *                     .ipPrefixes("10.10.10.10/30")
 *                     .name("example-ipGroup1")
 *                     .build())
 *                 .portGroups(
 *                     PortGroupPropertiesArgs.builder()
 *                         .name("example-portGroup1")
 *                         .ports("100-200")
 *                         .build(),
 *                     PortGroupPropertiesArgs.builder()
 *                         .name("example-portGroup2")
 *                         .ports(
 *                             "900",
 *                             "1000-2000")
 *                         .build())
 *                 .vlanGroups(VlanGroupPropertiesArgs.builder()
 *                     .name("exmaple-vlanGroup")
 *                     .vlans(
 *                         "10",
 *                         "100-200")
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .matchConfigurations(NetworkTapRuleMatchConfigurationArgs.builder()
 *                 .actions(NetworkTapRuleActionArgs.builder()
 *                     .destinationId("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/neighborGroups/example-neighborGroup")
 *                     .isTimestampEnabled("True")
 *                     .matchConfigurationName("match1")
 *                     .truncate("100")
 *                     .type("Drop")
 *                     .build())
 *                 .ipAddressType("IPv4")
 *                 .matchConditions(NetworkTapRuleMatchConditionArgs.builder()
 *                     .encapsulationType("None")
 *                     .ipCondition(IpMatchConditionArgs.builder()
 *                         .ipGroupNames("example-ipGroup")
 *                         .ipPrefixValues("10.10.10.10/20")
 *                         .prefixType("Prefix")
 *                         .type("SourceIP")
 *                         .build())
 *                     .portCondition(PortConditionArgs.builder()
 *                         .layer4Protocol("TCP")
 *                         .portGroupNames("example-portGroup1")
 *                         .portType("SourcePort")
 *                         .ports("100")
 *                         .build())
 *                     .protocolTypes("TCP")
 *                     .vlanMatchCondition(VlanMatchConditionArgs.builder()
 *                         .innerVlans("11-20")
 *                         .vlanGroupNames("exmaple-vlanGroup")
 *                         .vlans("10")
 *                         .build())
 *                     .build())
 *                 .matchConfigurationName("config1")
 *                 .sequenceNumber(10)
 *                 .build())
 *             .networkTapRuleName("example-tapRule")
 *             .pollingIntervalInSeconds(30)
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("keyID", "keyValue"))
 *             .tapRulesUrl("https://microsoft.com/a")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkTapRule example-tapRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkTapRules/{networkTapRuleName}
 * ```
 */
public class NetworkTapRule internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkTapRule,
) : KotlinCustomResource(javaResource, NetworkTapRuleMapper) {
    /**
     * Administrative state of the resource.
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration state of the resource.
     */
    public val configurationState: Output<String>
        get() = javaResource.configurationState().applyValue({ args0 -> args0 })

    /**
     * Input method to configure Network Tap Rule.
     */
    public val configurationType: Output<String>
        get() = javaResource.configurationType().applyValue({ args0 -> args0 })

    /**
     * List of dynamic match configurations.
     */
    public val dynamicMatchConfigurations: Output<List<CommonDynamicMatchConfigurationResponse>>?
        get() = javaResource.dynamicMatchConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        commonDynamicMatchConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The last sync timestamp.
     */
    public val lastSyncedTime: Output<String>
        get() = javaResource.lastSyncedTime().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * List of match configurations.
     */
    public val matchConfigurations: Output<List<NetworkTapRuleMatchConfigurationResponse>>?
        get() = javaResource.matchConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        networkTapRuleMatchConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARM resource Id of the NetworkTap.
     */
    public val networkTapId: Output<String>
        get() = javaResource.networkTapId().applyValue({ args0 -> args0 })

    /**
     * Polling interval in seconds.
     */
    public val pollingIntervalInSeconds: Output<Int>?
        get() = javaResource.pollingIntervalInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Network Tap Rules file URL.
     */
    public val tapRulesUrl: Output<String>?
        get() = javaResource.tapRulesUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkTapRuleMapper : ResourceMapper<NetworkTapRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkTapRule::class == javaResource::class

    override fun map(javaResource: Resource): NetworkTapRule = NetworkTapRule(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.NetworkTapRule,
    )
}

/**
 * @see [NetworkTapRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkTapRule].
 */
public suspend fun networkTapRule(
    name: String,
    block: suspend NetworkTapRuleResourceBuilder.() -> Unit,
): NetworkTapRule {
    val builder = NetworkTapRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkTapRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkTapRule(name: String): NetworkTapRule {
    val builder = NetworkTapRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
