@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.Layer2ConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.Layer3ConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.Layer2ConfigurationResponse.Companion.toKotlin as layer2ConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.Layer3ConfigurationResponse.Companion.toKotlin as layer3ConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkToNetworkInterconnect].
 */
@PulumiTagMarker
public class NetworkToNetworkInterconnectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkToNetworkInterconnectArgs = NetworkToNetworkInterconnectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkToNetworkInterconnectArgsBuilder.() -> Unit) {
        val builder = NetworkToNetworkInterconnectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkToNetworkInterconnect {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnect(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkToNetworkInterconnect(builtJavaResource)
    }
}

/**
 * The NetworkToNetworkInterconnect resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkToNetworkInterconnects_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkToNetworkInterconnect = new AzureNative.ManagedNetworkFabric.NetworkToNetworkInterconnect("networkToNetworkInterconnect", new()
 *     {
 *         IsManagementType = AzureNative.ManagedNetworkFabric.BooleanEnumProperty.True,
 *         Layer2Configuration = new AzureNative.ManagedNetworkFabric.Inputs.Layer2ConfigurationArgs
 *         {
 *             Mtu = 1500,
 *             PortCount = 10,
 *         },
 *         Layer3Configuration = new AzureNative.ManagedNetworkFabric.Inputs.Layer3ConfigurationArgs
 *         {
 *             ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
 *             ImportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1",
 *             PeerASN = 50272,
 *             PrimaryIpv4Prefix = "172.31.0.0/31",
 *             PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a0/126",
 *             SecondaryIpv4Prefix = "172.31.0.20/31",
 *             SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::a4/126",
 *             VlanId = 2064,
 *         },
 *         NetworkFabricName = "FabricName",
 *         NetworkToNetworkInterconnectName = "DefaultNNI",
 *         NniType = AzureNative.ManagedNetworkFabric.NniType.CE,
 *         ResourceGroupName = "resourceGroupName",
 *         UseOptionB = AzureNative.ManagedNetworkFabric.BooleanEnumProperty.False,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkToNetworkInterconnect(ctx, "networkToNetworkInterconnect", &managednetworkfabric.NetworkToNetworkInterconnectArgs{
 * 			IsManagementType: pulumi.String(managednetworkfabric.BooleanEnumPropertyTrue),
 * 			Layer2Configuration: &managednetworkfabric.Layer2ConfigurationArgs{
 * 				Mtu:       pulumi.Int(1500),
 * 				PortCount: pulumi.Int(10),
 * 			},
 * 			Layer3Configuration: &managednetworkfabric.Layer3ConfigurationArgs{
 * 				ExportRoutePolicyId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"),
 * 				ImportRoutePolicyId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1"),
 * 				PeerASN:             pulumi.Int(50272),
 * 				PrimaryIpv4Prefix:   pulumi.String("172.31.0.0/31"),
 * 				PrimaryIpv6Prefix:   pulumi.String("3FFE:FFFF:0:CD30::a0/126"),
 * 				SecondaryIpv4Prefix: pulumi.String("172.31.0.20/31"),
 * 				SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a4/126"),
 * 				VlanId:              pulumi.Int(2064),
 * 			},
 * 			NetworkFabricName:                pulumi.String("FabricName"),
 * 			NetworkToNetworkInterconnectName: pulumi.String("DefaultNNI"),
 * 			NniType:                          pulumi.String(managednetworkfabric.NniTypeCE),
 * 			ResourceGroupName:                pulumi.String("resourceGroupName"),
 * 			UseOptionB:                       pulumi.String(managednetworkfabric.BooleanEnumPropertyFalse),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnect;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnectArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.Layer2ConfigurationArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.Layer3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkToNetworkInterconnect = new NetworkToNetworkInterconnect("networkToNetworkInterconnect", NetworkToNetworkInterconnectArgs.builder()
 *             .isManagementType("True")
 *             .layer2Configuration(Layer2ConfigurationArgs.builder()
 *                 .mtu(1500)
 *                 .portCount(10)
 *                 .build())
 *             .layer3Configuration(Layer3ConfigurationArgs.builder()
 *                 .exportRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2")
 *                 .importRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1")
 *                 .peerASN(50272)
 *                 .primaryIpv4Prefix("172.31.0.0/31")
 *                 .primaryIpv6Prefix("3FFE:FFFF:0:CD30::a0/126")
 *                 .secondaryIpv4Prefix("172.31.0.20/31")
 *                 .secondaryIpv6Prefix("3FFE:FFFF:0:CD30::a4/126")
 *                 .vlanId(2064)
 *                 .build())
 *             .networkFabricName("FabricName")
 *             .networkToNetworkInterconnectName("DefaultNNI")
 *             .nniType("CE")
 *             .resourceGroupName("resourceGroupName")
 *             .useOptionB("False")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkToNetworkInterconnect DefaultNNI /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/networkToNetworkInterconnects/{networkToNetworkInterconnectName}
 * ```
 */
public class NetworkToNetworkInterconnect internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnect,
) : KotlinCustomResource(javaResource, NetworkToNetworkInterconnectMapper) {
    /**
     * Gets the administrativeState of the resource. Example -Enabled/Disabled
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * Configuration to use NNI for Infrastructure Management. Example: True/False.
     */
    public val isManagementType: Output<String>
        get() = javaResource.isManagementType().applyValue({ args0 -> args0 })

    /**
     * Common properties for Layer2Configuration.
     */
    public val layer2Configuration: Output<Layer2ConfigurationResponse>?
        get() = javaResource.layer2Configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> layer2ConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Common properties for Layer3Configuration.
     */
    public val layer3Configuration: Output<Layer3ConfigurationResponse>?
        get() = javaResource.layer3Configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> layer3ConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Type of NNI used. Example: CE | NPB
     */
    public val nniType: Output<String>?
        get() = javaResource.nniType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
     */
    public val useOptionB: Output<String>
        get() = javaResource.useOptionB().applyValue({ args0 -> args0 })
}

public object NetworkToNetworkInterconnectMapper : ResourceMapper<NetworkToNetworkInterconnect> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnect::class == javaResource::class

    override fun map(javaResource: Resource): NetworkToNetworkInterconnect =
        NetworkToNetworkInterconnect(
            javaResource as
                com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnect,
        )
}

/**
 * @see [NetworkToNetworkInterconnect].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkToNetworkInterconnect].
 */
public suspend fun networkToNetworkInterconnect(
    name: String,
    block: suspend NetworkToNetworkInterconnectResourceBuilder.() -> Unit,
): NetworkToNetworkInterconnect {
    val builder = NetworkToNetworkInterconnectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkToNetworkInterconnect].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkToNetworkInterconnect(name: String): NetworkToNetworkInterconnect {
    val builder = NetworkToNetworkInterconnectResourceBuilder()
    builder.name(name)
    return builder.build()
}
