@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.RoutePolicyArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.RoutePolicyStatementPropertiesArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.RoutePolicyStatementPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The RoutePolicy resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### RoutePolicies_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routePolicy = new AzureNative.ManagedNetworkFabric.RoutePolicy("routePolicy", new()
 *     {
 *         Annotation = "annotationValue",
 *         Location = "EastUS",
 *         ResourceGroupName = "rgRoutePolicies",
 *         RoutePolicyName = "routePolicyName",
 *         Statements = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.RoutePolicyStatementPropertiesArgs
 *             {
 *                 Action = new AzureNative.ManagedNetworkFabric.Inputs.StatementActionPropertiesArgs
 *                 {
 *                     ActionType = AzureNative.ManagedNetworkFabric.CommunityActionTypes.Permit,
 *                     IpCommunityProperties = new AzureNative.ManagedNetworkFabric.Inputs.ActionIpCommunityPropertiesArgs
 *                     {
 *                         Add = new AzureNative.ManagedNetworkFabric.Inputs.IpCommunityIdListArgs
 *                         {
 *                             IpCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                             },
 *                         },
 *                         Delete = new AzureNative.ManagedNetworkFabric.Inputs.IpCommunityIdListArgs
 *                         {
 *                             IpCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                             },
 *                         },
 *                         Set = new AzureNative.ManagedNetworkFabric.Inputs.IpCommunityIdListArgs
 *                         {
 *                             IpCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                             },
 *                         },
 *                     },
 *                     IpExtendedCommunityProperties = new AzureNative.ManagedNetworkFabric.Inputs.ActionIpExtendedCommunityPropertiesArgs
 *                     {
 *                         Add = new AzureNative.ManagedNetworkFabric.Inputs.IpExtendedCommunityIdListArgs
 *                         {
 *                             IpExtendedCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                             },
 *                         },
 *                         Delete = new AzureNative.ManagedNetworkFabric.Inputs.IpExtendedCommunityIdListArgs
 *                         {
 *                             IpExtendedCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                             },
 *                         },
 *                         Set = new AzureNative.ManagedNetworkFabric.Inputs.IpExtendedCommunityIdListArgs
 *                         {
 *                             IpExtendedCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                             },
 *                         },
 *                     },
 *                     LocalPreference = 20,
 *                 },
 *                 Annotation = "annotationValue",
 *                 Condition = new AzureNative.ManagedNetworkFabric.Inputs.StatementConditionPropertiesArgs
 *                 {
 *                     IpCommunityIds = new[]
 *                     {
 *                         "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                     },
 *                     IpExtendedCommunityIds = new[]
 *                     {
 *                         "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                     },
 *                     IpPrefixId = "subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/example-ipPrefix",
 *                 },
 *                 SequenceNumber = 7,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key8254", "" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewRoutePolicy(ctx, "routePolicy", &managednetworkfabric.RoutePolicyArgs{
 * 			Annotation:        pulumi.String("annotationValue"),
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("rgRoutePolicies"),
 * 			RoutePolicyName:   pulumi.String("routePolicyName"),
 * 			Statements: managednetworkfabric.RoutePolicyStatementPropertiesArray{
 * 				&managednetworkfabric.RoutePolicyStatementPropertiesArgs{
 * 					Action: &managednetworkfabric.StatementActionPropertiesArgs{
 * 						ActionType: pulumi.String(managednetworkfabric.CommunityActionTypesPermit),
 * 						IpCommunityProperties: &managednetworkfabric.ActionIpCommunityPropertiesArgs{
 * 							Add: &managednetworkfabric.IpCommunityIdListArgs{
 * 								IpCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 								},
 * 							},
 * 							Delete: &managednetworkfabric.IpCommunityIdListArgs{
 * 								IpCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 								},
 * 							},
 * 							Set: &managednetworkfabric.IpCommunityIdListArgs{
 * 								IpCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 								},
 * 							},
 * 						},
 * 						IpExtendedCommunityProperties: &managednetworkfabric.ActionIpExtendedCommunityPropertiesArgs{
 * 							Add: &managednetworkfabric.IpExtendedCommunityIdListArgs{
 * 								IpExtendedCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 								},
 * 							},
 * 							Delete: &managednetworkfabric.IpExtendedCommunityIdListArgs{
 * 								IpExtendedCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 								},
 * 							},
 * 							Set: &managednetworkfabric.IpExtendedCommunityIdListArgs{
 * 								IpExtendedCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 								},
 * 							},
 * 						},
 * 						LocalPreference: pulumi.Float64(20),
 * 					},
 * 					Annotation: pulumi.String("annotationValue"),
 * 					Condition: &managednetworkfabric.StatementConditionPropertiesArgs{
 * 						IpCommunityIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 						},
 * 						IpExtendedCommunityIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 						},
 * 						IpPrefixId: pulumi.String("subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/example-ipPrefix"),
 * 					},
 * 					SequenceNumber: pulumi.Float64(7),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key8254": pulumi.String(""),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.RoutePolicy;
 * import com.pulumi.azurenative.managednetworkfabric.RoutePolicyArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.RoutePolicyStatementPropertiesArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.StatementActionPropertiesArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpCommunityPropertiesArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.IpCommunityIdListArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpExtendedCommunityPropertiesArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.IpExtendedCommunityIdListArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.StatementConditionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routePolicy = new RoutePolicy("routePolicy", RoutePolicyArgs.builder()
 *             .annotation("annotationValue")
 *             .location("EastUS")
 *             .resourceGroupName("rgRoutePolicies")
 *             .routePolicyName("routePolicyName")
 *             .statements(RoutePolicyStatementPropertiesArgs.builder()
 *                 .action(StatementActionPropertiesArgs.builder()
 *                     .actionType("Permit")
 *                     .ipCommunityProperties(ActionIpCommunityPropertiesArgs.builder()
 *                         .add(IpCommunityIdListArgs.builder()
 *                             .ipCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName")
 *                             .build())
 *                         .delete(IpCommunityIdListArgs.builder()
 *                             .ipCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName")
 *                             .build())
 *                         .set(IpCommunityIdListArgs.builder()
 *                             .ipCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName")
 *                             .build())
 *                         .build())
 *                     .ipExtendedCommunityProperties(ActionIpExtendedCommunityPropertiesArgs.builder()
 *                         .add(IpExtendedCommunityIdListArgs.builder()
 *                             .ipExtendedCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName")
 *                             .build())
 *                         .delete(IpExtendedCommunityIdListArgs.builder()
 *                             .ipExtendedCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName")
 *                             .build())
 *                         .set(IpExtendedCommunityIdListArgs.builder()
 *                             .ipExtendedCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName")
 *                             .build())
 *                         .build())
 *                     .localPreference(20)
 *                     .build())
 *                 .annotation("annotationValue")
 *                 .condition(StatementConditionPropertiesArgs.builder()
 *                     .ipCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName")
 *                     .ipExtendedCommunityIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName")
 *                     .ipPrefixId("subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/example-ipPrefix")
 *                     .build())
 *                 .sequenceNumber(7)
 *                 .build())
 *             .tags(Map.of("key8254", ""))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:RoutePolicy routePolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}
 * ```
 * @property annotation Switch configuration description.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property routePolicyName Name of the Route Policy
 * @property statements Route Policy statements.
 * @property tags Resource tags.
 */
public data class RoutePolicyArgs(
    public val `annotation`: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routePolicyName: Output<String>? = null,
    public val statements: Output<List<RoutePolicyStatementPropertiesArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.RoutePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.RoutePolicyArgs =
        com.pulumi.azurenative.managednetworkfabric.RoutePolicyArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routePolicyName(routePolicyName?.applyValue({ args0 -> args0 }))
            .statements(
                statements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RoutePolicyArgs].
 */
@PulumiTagMarker
public class RoutePolicyArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routePolicyName: Output<String>? = null

    private var statements: Output<List<RoutePolicyStatementPropertiesArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("pyjyaajtohikxjmd")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hgcdwnovawodmhju")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("njxqjurdjtgmcwfj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the Route Policy
     */
    @JvmName("pwildfheirnjuwwx")
    public suspend fun routePolicyName(`value`: Output<String>) {
        this.routePolicyName = value
    }

    /**
     * @param value Route Policy statements.
     */
    @JvmName("cyhcpsvrqoisfbbu")
    public suspend fun statements(`value`: Output<List<RoutePolicyStatementPropertiesArgs>>) {
        this.statements = value
    }

    @JvmName("pntdqevrprailuet")
    public suspend fun statements(vararg values: Output<RoutePolicyStatementPropertiesArgs>) {
        this.statements = Output.all(values.asList())
    }

    /**
     * @param values Route Policy statements.
     */
    @JvmName("efymfrebreuoodgo")
    public suspend fun statements(values: List<Output<RoutePolicyStatementPropertiesArgs>>) {
        this.statements = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kyavysoylnsyiurb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("toiacqhrshlumbva")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("maqapftgsnghptmg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yhsnjscjlqvalppp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Route Policy
     */
    @JvmName("umclmkejalqqmcqp")
    public suspend fun routePolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routePolicyName = mapped
    }

    /**
     * @param value Route Policy statements.
     */
    @JvmName("mmdlonkgqiqqsvro")
    public suspend fun statements(`value`: List<RoutePolicyStatementPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param argument Route Policy statements.
     */
    @JvmName("omoliumoccbpqurd")
    public suspend fun statements(argument: List<suspend RoutePolicyStatementPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutePolicyStatementPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument Route Policy statements.
     */
    @JvmName("rcrosemxfpkhvrfl")
    public suspend fun statements(vararg argument: suspend RoutePolicyStatementPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutePolicyStatementPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument Route Policy statements.
     */
    @JvmName("gyrhvnljfeqftqpb")
    public suspend fun statements(argument: suspend RoutePolicyStatementPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutePolicyStatementPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param values Route Policy statements.
     */
    @JvmName("rmdtgiikacgdmcno")
    public suspend fun statements(vararg values: RoutePolicyStatementPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("irytqgatbfjtasyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mgjtopnkixfyivvb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RoutePolicyArgs = RoutePolicyArgs(
        `annotation` = `annotation`,
        location = location,
        resourceGroupName = resourceGroupName,
        routePolicyName = routePolicyName,
        statements = statements,
        tags = tags,
    )
}
