@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 *
 * `Internet` - Advertise routes to internet community.
 *  `LocalAS` - Advertise routes to only localAS peers.
 *  `NoAdvertise` - Don't advertise routes to any peer.
 * `NoExport` - Don't export to next AS.
 * `GShut` - Graceful Shutdown (GSHUT) withdraw routes before terminating BGP connection.
 */
public enum class WellKnownCommunities(
    public val javaValue: com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities> {
    Internet(com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities.Internet),
    LocalAS(com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities.LocalAS),
    NoAdvertise(com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities.NoAdvertise),
    NoExport(com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities.NoExport),
    GShut(com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities.GShut),
    ;

    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.enums.WellKnownCommunities): WellKnownCommunities = WellKnownCommunities.values().first { it.javaValue == javaType }
    }
}
