@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpCommunityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP Community Properties.
 * @property add IP Community ID list properties.
 * @property delete IP Community ID list properties.
 * @property set IP Community ID list properties.
 */
public data class ActionIpCommunityPropertiesArgs(
    public val add: Output<IpCommunityIdListArgs>? = null,
    public val delete: Output<IpCommunityIdListArgs>? = null,
    public val `set`: Output<IpCommunityIdListArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpCommunityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpCommunityPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpCommunityPropertiesArgs.builder()
            .add(add?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .delete(delete?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`set`(`set`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ActionIpCommunityPropertiesArgs].
 */
@PulumiTagMarker
public class ActionIpCommunityPropertiesArgsBuilder internal constructor() {
    private var add: Output<IpCommunityIdListArgs>? = null

    private var delete: Output<IpCommunityIdListArgs>? = null

    private var `set`: Output<IpCommunityIdListArgs>? = null

    /**
     * @param value IP Community ID list properties.
     */
    @JvmName("ybtykpnsoxqvtwvl")
    public suspend fun add(`value`: Output<IpCommunityIdListArgs>) {
        this.add = value
    }

    /**
     * @param value IP Community ID list properties.
     */
    @JvmName("tuhweqxfggojbwha")
    public suspend fun delete(`value`: Output<IpCommunityIdListArgs>) {
        this.delete = value
    }

    /**
     * @param value IP Community ID list properties.
     */
    @JvmName("mavedymedtqhpubw")
    public suspend fun `set`(`value`: Output<IpCommunityIdListArgs>) {
        this.`set` = value
    }

    /**
     * @param value IP Community ID list properties.
     */
    @JvmName("fgmjvxseenwmnonn")
    public suspend fun add(`value`: IpCommunityIdListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.add = mapped
    }

    /**
     * @param argument IP Community ID list properties.
     */
    @JvmName("cflesjlgfnaygupe")
    public suspend fun add(argument: suspend IpCommunityIdListArgsBuilder.() -> Unit) {
        val toBeMapped = IpCommunityIdListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.add = mapped
    }

    /**
     * @param value IP Community ID list properties.
     */
    @JvmName("msbgqqqrixpwxdqj")
    public suspend fun delete(`value`: IpCommunityIdListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param argument IP Community ID list properties.
     */
    @JvmName("kawrhxuneisjskuy")
    public suspend fun delete(argument: suspend IpCommunityIdListArgsBuilder.() -> Unit) {
        val toBeMapped = IpCommunityIdListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.delete = mapped
    }

    /**
     * @param value IP Community ID list properties.
     */
    @JvmName("mgcbjgwrfnfbsehc")
    public suspend fun `set`(`value`: IpCommunityIdListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`set` = mapped
    }

    /**
     * @param argument IP Community ID list properties.
     */
    @JvmName("myaueagnixfvseed")
    public suspend fun `set`(argument: suspend IpCommunityIdListArgsBuilder.() -> Unit) {
        val toBeMapped = IpCommunityIdListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`set` = mapped
    }

    internal fun build(): ActionIpCommunityPropertiesArgs = ActionIpCommunityPropertiesArgs(
        add = add,
        delete = delete,
        `set` = `set`,
    )
}
