@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpExtendedCommunityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP Extended Community Properties.
 * @property add IP Extended Community Id list properties.
 * @property delete IP Extended Community Id list properties.
 * @property set IP Extended Community Id list properties.
 */
public data class ActionIpExtendedCommunityPropertiesArgs(
    public val add: Output<IpExtendedCommunityIdListArgs>? = null,
    public val delete: Output<IpExtendedCommunityIdListArgs>? = null,
    public val `set`: Output<IpExtendedCommunityIdListArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpExtendedCommunityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpExtendedCommunityPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.ActionIpExtendedCommunityPropertiesArgs.builder()
            .add(add?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .delete(delete?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`set`(`set`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ActionIpExtendedCommunityPropertiesArgs].
 */
@PulumiTagMarker
public class ActionIpExtendedCommunityPropertiesArgsBuilder internal constructor() {
    private var add: Output<IpExtendedCommunityIdListArgs>? = null

    private var delete: Output<IpExtendedCommunityIdListArgs>? = null

    private var `set`: Output<IpExtendedCommunityIdListArgs>? = null

    /**
     * @param value IP Extended Community Id list properties.
     */
    @JvmName("milrtdnjhinxyqrf")
    public suspend fun add(`value`: Output<IpExtendedCommunityIdListArgs>) {
        this.add = value
    }

    /**
     * @param value IP Extended Community Id list properties.
     */
    @JvmName("qgrocwpmqhhrvbwn")
    public suspend fun delete(`value`: Output<IpExtendedCommunityIdListArgs>) {
        this.delete = value
    }

    /**
     * @param value IP Extended Community Id list properties.
     */
    @JvmName("fibaufmukvbwaxhq")
    public suspend fun `set`(`value`: Output<IpExtendedCommunityIdListArgs>) {
        this.`set` = value
    }

    /**
     * @param value IP Extended Community Id list properties.
     */
    @JvmName("akfyndvmrtcxrtsy")
    public suspend fun add(`value`: IpExtendedCommunityIdListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.add = mapped
    }

    /**
     * @param argument IP Extended Community Id list properties.
     */
    @JvmName("vqbherxpmmorspwv")
    public suspend fun add(argument: suspend IpExtendedCommunityIdListArgsBuilder.() -> Unit) {
        val toBeMapped = IpExtendedCommunityIdListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.add = mapped
    }

    /**
     * @param value IP Extended Community Id list properties.
     */
    @JvmName("cqgmxpoypcqiddum")
    public suspend fun delete(`value`: IpExtendedCommunityIdListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param argument IP Extended Community Id list properties.
     */
    @JvmName("vtvtvefxwcpkjtci")
    public suspend fun delete(argument: suspend IpExtendedCommunityIdListArgsBuilder.() -> Unit) {
        val toBeMapped = IpExtendedCommunityIdListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.delete = mapped
    }

    /**
     * @param value IP Extended Community Id list properties.
     */
    @JvmName("pwbnqygeqbvgmrfa")
    public suspend fun `set`(`value`: IpExtendedCommunityIdListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`set` = mapped
    }

    /**
     * @param argument IP Extended Community Id list properties.
     */
    @JvmName("wqoqgudmpxqdonfo")
    public suspend fun `set`(argument: suspend IpExtendedCommunityIdListArgsBuilder.() -> Unit) {
        val toBeMapped = IpExtendedCommunityIdListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`set` = mapped
    }

    internal fun build(): ActionIpExtendedCommunityPropertiesArgs =
        ActionIpExtendedCommunityPropertiesArgs(
            add = add,
            delete = delete,
            `set` = `set`,
        )
}
