@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Aggregate Route properties.
 * @property prefix Prefix of the aggregate Route.
 */
public data class AggregateRouteArgs(
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AggregateRouteArgs].
 */
@PulumiTagMarker
public class AggregateRouteArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    /**
     * @param value Prefix of the aggregate Route.
     */
    @JvmName("efmkqjdjgmyjsicl")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Prefix of the aggregate Route.
     */
    @JvmName("lpovqsjhcyuqitll")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): AggregateRouteArgs = AggregateRouteArgs(
        prefix = prefix,
    )
}
