@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * List of IPv4 and IPv6 route configurations.
 * @property ipv4Routes List of IPv4 Route prefixes.
 * @property ipv6Routes List of IPv6 Routes prefixes.
 */
public data class AggregateRouteConfigurationArgs(
    public val ipv4Routes: Output<List<AggregateRouteArgs>>? = null,
    public val ipv6Routes: Output<List<AggregateRouteArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.AggregateRouteConfigurationArgs.builder()
            .ipv4Routes(
                ipv4Routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipv6Routes(
                ipv6Routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AggregateRouteConfigurationArgs].
 */
@PulumiTagMarker
public class AggregateRouteConfigurationArgsBuilder internal constructor() {
    private var ipv4Routes: Output<List<AggregateRouteArgs>>? = null

    private var ipv6Routes: Output<List<AggregateRouteArgs>>? = null

    /**
     * @param value List of IPv4 Route prefixes.
     */
    @JvmName("ngexanyjjxooynos")
    public suspend fun ipv4Routes(`value`: Output<List<AggregateRouteArgs>>) {
        this.ipv4Routes = value
    }

    @JvmName("agahncmwkfxoqyyn")
    public suspend fun ipv4Routes(vararg values: Output<AggregateRouteArgs>) {
        this.ipv4Routes = Output.all(values.asList())
    }

    /**
     * @param values List of IPv4 Route prefixes.
     */
    @JvmName("bfdxkogchbjkrcvu")
    public suspend fun ipv4Routes(values: List<Output<AggregateRouteArgs>>) {
        this.ipv4Routes = Output.all(values)
    }

    /**
     * @param value List of IPv6 Routes prefixes.
     */
    @JvmName("macsdvedgcijmyjx")
    public suspend fun ipv6Routes(`value`: Output<List<AggregateRouteArgs>>) {
        this.ipv6Routes = value
    }

    @JvmName("bdpqbpanljpccech")
    public suspend fun ipv6Routes(vararg values: Output<AggregateRouteArgs>) {
        this.ipv6Routes = Output.all(values.asList())
    }

    /**
     * @param values List of IPv6 Routes prefixes.
     */
    @JvmName("qjjsfynxgyrrjbnm")
    public suspend fun ipv6Routes(values: List<Output<AggregateRouteArgs>>) {
        this.ipv6Routes = Output.all(values)
    }

    /**
     * @param value List of IPv4 Route prefixes.
     */
    @JvmName("fnsmxtgyleochqbe")
    public suspend fun ipv4Routes(`value`: List<AggregateRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Routes = mapped
    }

    /**
     * @param argument List of IPv4 Route prefixes.
     */
    @JvmName("qjxsinguenakkdhw")
    public suspend fun ipv4Routes(argument: List<suspend AggregateRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AggregateRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv4Routes = mapped
    }

    /**
     * @param argument List of IPv4 Route prefixes.
     */
    @JvmName("svyxcsnglplkfnfg")
    public suspend fun ipv4Routes(vararg argument: suspend AggregateRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AggregateRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv4Routes = mapped
    }

    /**
     * @param argument List of IPv4 Route prefixes.
     */
    @JvmName("qwfsjoehjwodeiyn")
    public suspend fun ipv4Routes(argument: suspend AggregateRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AggregateRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipv4Routes = mapped
    }

    /**
     * @param values List of IPv4 Route prefixes.
     */
    @JvmName("tmouyfxlhtmraofb")
    public suspend fun ipv4Routes(vararg values: AggregateRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Routes = mapped
    }

    /**
     * @param value List of IPv6 Routes prefixes.
     */
    @JvmName("iudhoaxycnpjkecx")
    public suspend fun ipv6Routes(`value`: List<AggregateRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Routes = mapped
    }

    /**
     * @param argument List of IPv6 Routes prefixes.
     */
    @JvmName("kywbhwaebgkhxbcu")
    public suspend fun ipv6Routes(argument: List<suspend AggregateRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AggregateRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv6Routes = mapped
    }

    /**
     * @param argument List of IPv6 Routes prefixes.
     */
    @JvmName("sgrofreqvofqwviq")
    public suspend fun ipv6Routes(vararg argument: suspend AggregateRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AggregateRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv6Routes = mapped
    }

    /**
     * @param argument List of IPv6 Routes prefixes.
     */
    @JvmName("vatymggrtsnfbdvf")
    public suspend fun ipv6Routes(argument: suspend AggregateRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AggregateRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipv6Routes = mapped
    }

    /**
     * @param values List of IPv6 Routes prefixes.
     */
    @JvmName("ajxxsqtgcncjtjdf")
    public suspend fun ipv6Routes(vararg values: AggregateRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Routes = mapped
    }

    internal fun build(): AggregateRouteConfigurationArgs = AggregateRouteConfigurationArgs(
        ipv4Routes = ipv4Routes,
        ipv6Routes = ipv6Routes,
    )
}
