@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetInternalNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property internalNetworkName Name of the InternalNetwork
 * @property l3IsolationDomainName Name of the L3IsolationDomain
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetInternalNetworkPlainArgs(
    public val internalNetworkName: String,
    public val l3IsolationDomainName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetInternalNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetInternalNetworkPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetInternalNetworkPlainArgs.builder()
            .internalNetworkName(internalNetworkName.let({ args0 -> args0 }))
            .l3IsolationDomainName(l3IsolationDomainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInternalNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetInternalNetworkPlainArgsBuilder internal constructor() {
    private var internalNetworkName: String? = null

    private var l3IsolationDomainName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the InternalNetwork
     */
    @JvmName("crylyxqerebqrvfh")
    public suspend fun internalNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.internalNetworkName = mapped
    }

    /**
     * @param value Name of the L3IsolationDomain
     */
    @JvmName("nhdvavkudawaxhql")
    public suspend fun l3IsolationDomainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.l3IsolationDomainName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("scqcslfjsoqgvnjs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInternalNetworkPlainArgs = GetInternalNetworkPlainArgs(
        internalNetworkName = internalNetworkName ?: throw PulumiNullFieldException("internalNetworkName"),
        l3IsolationDomainName = l3IsolationDomainName ?: throw
            PulumiNullFieldException("l3IsolationDomainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
