@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetIpPrefixPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipPrefixName Name of the IP Prefix
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetIpPrefixPlainArgs(
    public val ipPrefixName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetIpPrefixPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetIpPrefixPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetIpPrefixPlainArgs.builder()
            .ipPrefixName(ipPrefixName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpPrefixPlainArgs].
 */
@PulumiTagMarker
public class GetIpPrefixPlainArgsBuilder internal constructor() {
    private var ipPrefixName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the IP Prefix
     */
    @JvmName("orxlnyefebglsbfy")
    public suspend fun ipPrefixName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipPrefixName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hqlabnwvsbriehap")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIpPrefixPlainArgs = GetIpPrefixPlainArgs(
        ipPrefixName = ipPrefixName ?: throw PulumiNullFieldException("ipPrefixName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
