@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNeighborGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property neighborGroupName Name of the Neighbor Group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNeighborGroupPlainArgs(
    public val neighborGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNeighborGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetNeighborGroupPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNeighborGroupPlainArgs.builder()
            .neighborGroupName(neighborGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNeighborGroupPlainArgs].
 */
@PulumiTagMarker
public class GetNeighborGroupPlainArgsBuilder internal constructor() {
    private var neighborGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Neighbor Group.
     */
    @JvmName("cqqjnordkknxaonp")
    public suspend fun neighborGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.neighborGroupName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xtibvusvuoraefsd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNeighborGroupPlainArgs = GetNeighborGroupPlainArgs(
        neighborGroupName = neighborGroupName ?: throw PulumiNullFieldException("neighborGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
