@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkFabricControllerName Name of the Network Fabric Controller
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkFabricControllerPlainArgs(
    public val networkFabricControllerName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricControllerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricControllerPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricControllerPlainArgs.builder()
            .networkFabricControllerName(networkFabricControllerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkFabricControllerPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkFabricControllerPlainArgsBuilder internal constructor() {
    private var networkFabricControllerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Fabric Controller
     */
    @JvmName("mdtpjqolmtguxkxw")
    public suspend fun networkFabricControllerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFabricControllerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lxdefdnqivspxwxe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkFabricControllerPlainArgs = GetNetworkFabricControllerPlainArgs(
        networkFabricControllerName = networkFabricControllerName ?: throw
            PulumiNullFieldException("networkFabricControllerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
