@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkFabricName Name of the Network Fabric
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkFabricPlainArgs(
    public val networkFabricName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkFabricPlainArgs.builder()
            .networkFabricName(networkFabricName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkFabricPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkFabricPlainArgsBuilder internal constructor() {
    private var networkFabricName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Fabric
     */
    @JvmName("bcwdrumeljwuqrff")
    public suspend fun networkFabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFabricName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cccaokqkumxtefhh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkFabricPlainArgs = GetNetworkFabricPlainArgs(
        networkFabricName = networkFabricName ?: throw PulumiNullFieldException("networkFabricName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
