@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkRackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkRackName Name of the Network Rack
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkRackPlainArgs(
    public val networkRackName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkRackPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkRackPlainArgs = com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkRackPlainArgs.builder()
        .networkRackName(networkRackName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkRackPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkRackPlainArgsBuilder internal constructor() {
    private var networkRackName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Rack
     */
    @JvmName("xsvtsghdfexurpxq")
    public suspend fun networkRackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkRackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gadamggbncxekwdo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkRackPlainArgs = GetNetworkRackPlainArgs(
        networkRackName = networkRackName ?: throw PulumiNullFieldException("networkRackName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
