@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkTapName Name of the Network Tap.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkTapPlainArgs(
    public val networkTapName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapPlainArgs.builder()
            .networkTapName(networkTapName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkTapPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkTapPlainArgsBuilder internal constructor() {
    private var networkTapName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Tap.
     */
    @JvmName("vapfkuxaquskqvoi")
    public suspend fun networkTapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkTapName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vlvsqoajeypnuaey")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkTapPlainArgs = GetNetworkTapPlainArgs(
        networkTapName = networkTapName ?: throw PulumiNullFieldException("networkTapName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
