@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.IpExtendedCommunityIdListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IP Extended Community Id list properties.
 * @property ipExtendedCommunityIds List of IP Extended Community resource IDs.
 */
public data class IpExtendedCommunityIdListArgs(
    public val ipExtendedCommunityIds: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.IpExtendedCommunityIdListArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.IpExtendedCommunityIdListArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.IpExtendedCommunityIdListArgs.builder()
            .ipExtendedCommunityIds(
                ipExtendedCommunityIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [IpExtendedCommunityIdListArgs].
 */
@PulumiTagMarker
public class IpExtendedCommunityIdListArgsBuilder internal constructor() {
    private var ipExtendedCommunityIds: Output<List<String>>? = null

    /**
     * @param value List of IP Extended Community resource IDs.
     */
    @JvmName("trwkpuwscdqkcdbo")
    public suspend fun ipExtendedCommunityIds(`value`: Output<List<String>>) {
        this.ipExtendedCommunityIds = value
    }

    @JvmName("irepscpfevquntsw")
    public suspend fun ipExtendedCommunityIds(vararg values: Output<String>) {
        this.ipExtendedCommunityIds = Output.all(values.asList())
    }

    /**
     * @param values List of IP Extended Community resource IDs.
     */
    @JvmName("gomspcxhphfhvqyb")
    public suspend fun ipExtendedCommunityIds(values: List<Output<String>>) {
        this.ipExtendedCommunityIds = Output.all(values)
    }

    /**
     * @param value List of IP Extended Community resource IDs.
     */
    @JvmName("elyshgovbgflqqgr")
    public suspend fun ipExtendedCommunityIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipExtendedCommunityIds = mapped
    }

    /**
     * @param values List of IP Extended Community resource IDs.
     */
    @JvmName("fowgccuotswsvyvh")
    public suspend fun ipExtendedCommunityIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipExtendedCommunityIds = mapped
    }

    internal fun build(): IpExtendedCommunityIdListArgs = IpExtendedCommunityIdListArgs(
        ipExtendedCommunityIds = ipExtendedCommunityIds,
    )
}
