@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.IpGroupPropertiesArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.IPAddressType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IP Group properties.
 * @property ipAddressType IP Address type.
 * @property ipPrefixes List of IP Prefixes.
 * @property name IP Group name.
 */
public data class IpGroupPropertiesArgs(
    public val ipAddressType: Output<Either<String, IPAddressType>>? = null,
    public val ipPrefixes: Output<List<String>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.IpGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.IpGroupPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.IpGroupPropertiesArgs.builder()
            .ipAddressType(
                ipAddressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipPrefixes(ipPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpGroupPropertiesArgs].
 */
@PulumiTagMarker
public class IpGroupPropertiesArgsBuilder internal constructor() {
    private var ipAddressType: Output<Either<String, IPAddressType>>? = null

    private var ipPrefixes: Output<List<String>>? = null

    private var name: Output<String>? = null

    /**
     * @param value IP Address type.
     */
    @JvmName("trhlsovunikbhmow")
    public suspend fun ipAddressType(`value`: Output<Either<String, IPAddressType>>) {
        this.ipAddressType = value
    }

    /**
     * @param value List of IP Prefixes.
     */
    @JvmName("fgpsrjpylrxoijql")
    public suspend fun ipPrefixes(`value`: Output<List<String>>) {
        this.ipPrefixes = value
    }

    @JvmName("kxrltvveniwfqond")
    public suspend fun ipPrefixes(vararg values: Output<String>) {
        this.ipPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of IP Prefixes.
     */
    @JvmName("desdxtamqqhykkxw")
    public suspend fun ipPrefixes(values: List<Output<String>>) {
        this.ipPrefixes = Output.all(values)
    }

    /**
     * @param value IP Group name.
     */
    @JvmName("yqmqywtpalidcqcv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value IP Address type.
     */
    @JvmName("lbrephcqpawplmsb")
    public suspend fun ipAddressType(`value`: Either<String, IPAddressType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value IP Address type.
     */
    @JvmName("bsykptqqtbihdbsd")
    public fun ipAddressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value IP Address type.
     */
    @JvmName("suanfcdpuyjtjlst")
    public fun ipAddressType(`value`: IPAddressType) {
        val toBeMapped = Either.ofRight<String, IPAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value List of IP Prefixes.
     */
    @JvmName("xlbftemkjcfncoln")
    public suspend fun ipPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPrefixes = mapped
    }

    /**
     * @param values List of IP Prefixes.
     */
    @JvmName("cpygcyhqxrlefoje")
    public suspend fun ipPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipPrefixes = mapped
    }

    /**
     * @param value IP Group name.
     */
    @JvmName("vxaokiwxkeltokke")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IpGroupPropertiesArgs = IpGroupPropertiesArgs(
        ipAddressType = ipAddressType,
        ipPrefixes = ipPrefixes,
        name = name,
    )
}
