@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.Layer2ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * layer2Configuration
 * @property mtu MTU of the packets between PE & CE.
 * @property portCount Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
 */
public data class Layer2ConfigurationArgs(
    public val mtu: Output<Int>,
    public val portCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.Layer2ConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.Layer2ConfigurationArgs = com.pulumi.azurenative.managednetworkfabric.inputs.Layer2ConfigurationArgs.builder()
        .mtu(mtu.applyValue({ args0 -> args0 }))
        .portCount(portCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Layer2ConfigurationArgs].
 */
@PulumiTagMarker
public class Layer2ConfigurationArgsBuilder internal constructor() {
    private var mtu: Output<Int>? = null

    private var portCount: Output<Int>? = null

    /**
     * @param value MTU of the packets between PE & CE.
     */
    @JvmName("vuknnlfbvcmvsram")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
     */
    @JvmName("vidynarctmcvpjhy")
    public suspend fun portCount(`value`: Output<Int>) {
        this.portCount = value
    }

    /**
     * @param value MTU of the packets between PE & CE.
     */
    @JvmName("dcwhqurgcnqnvymp")
    public suspend fun mtu(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
     */
    @JvmName("yyojjeynjowbckrk")
    public suspend fun portCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portCount = mapped
    }

    internal fun build(): Layer2ConfigurationArgs = Layer2ConfigurationArgs(
        mtu = mtu ?: throw PulumiNullFieldException("mtu"),
        portCount = portCount,
    )
}
