@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.Layer3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * layer3Configuration
 * @property exportRoutePolicyId exportRoutePolicyId
 * @property importRoutePolicyId importRoutePolicyId
 * @property peerASN ASN of PE devices for CE/PE connectivity.Example : 28
 * @property primaryIpv4Prefix IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property primaryIpv6Prefix IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv4Prefix Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv6Prefix Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property vlanId VLAN for CE/PE Layer 3 connectivity.Example : 501
 */
public data class Layer3ConfigurationArgs(
    public val exportRoutePolicyId: Output<String>? = null,
    public val importRoutePolicyId: Output<String>? = null,
    public val peerASN: Output<Int>? = null,
    public val primaryIpv4Prefix: Output<String>? = null,
    public val primaryIpv6Prefix: Output<String>? = null,
    public val secondaryIpv4Prefix: Output<String>? = null,
    public val secondaryIpv6Prefix: Output<String>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.Layer3ConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.Layer3ConfigurationArgs = com.pulumi.azurenative.managednetworkfabric.inputs.Layer3ConfigurationArgs.builder()
        .exportRoutePolicyId(exportRoutePolicyId?.applyValue({ args0 -> args0 }))
        .importRoutePolicyId(importRoutePolicyId?.applyValue({ args0 -> args0 }))
        .peerASN(peerASN?.applyValue({ args0 -> args0 }))
        .primaryIpv4Prefix(primaryIpv4Prefix?.applyValue({ args0 -> args0 }))
        .primaryIpv6Prefix(primaryIpv6Prefix?.applyValue({ args0 -> args0 }))
        .secondaryIpv4Prefix(secondaryIpv4Prefix?.applyValue({ args0 -> args0 }))
        .secondaryIpv6Prefix(secondaryIpv6Prefix?.applyValue({ args0 -> args0 }))
        .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Layer3ConfigurationArgs].
 */
@PulumiTagMarker
public class Layer3ConfigurationArgsBuilder internal constructor() {
    private var exportRoutePolicyId: Output<String>? = null

    private var importRoutePolicyId: Output<String>? = null

    private var peerASN: Output<Int>? = null

    private var primaryIpv4Prefix: Output<String>? = null

    private var primaryIpv6Prefix: Output<String>? = null

    private var secondaryIpv4Prefix: Output<String>? = null

    private var secondaryIpv6Prefix: Output<String>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value exportRoutePolicyId
     */
    @JvmName("njvtpeemwhctdmmq")
    public suspend fun exportRoutePolicyId(`value`: Output<String>) {
        this.exportRoutePolicyId = value
    }

    /**
     * @param value importRoutePolicyId
     */
    @JvmName("ggbbneesdsregvdk")
    public suspend fun importRoutePolicyId(`value`: Output<String>) {
        this.importRoutePolicyId = value
    }

    /**
     * @param value ASN of PE devices for CE/PE connectivity.Example : 28
     */
    @JvmName("gtyiofvkwfyjbeoe")
    public suspend fun peerASN(`value`: Output<Int>) {
        this.peerASN = value
    }

    /**
     * @param value IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("pwrkgkthmolrwqpb")
    public suspend fun primaryIpv4Prefix(`value`: Output<String>) {
        this.primaryIpv4Prefix = value
    }

    /**
     * @param value IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("oqjrwsakgmyobpds")
    public suspend fun primaryIpv6Prefix(`value`: Output<String>) {
        this.primaryIpv6Prefix = value
    }

    /**
     * @param value Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("vmnemrwwqnscubdm")
    public suspend fun secondaryIpv4Prefix(`value`: Output<String>) {
        this.secondaryIpv4Prefix = value
    }

    /**
     * @param value Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("lxrrjresfqexuqvx")
    public suspend fun secondaryIpv6Prefix(`value`: Output<String>) {
        this.secondaryIpv6Prefix = value
    }

    /**
     * @param value VLAN for CE/PE Layer 3 connectivity.Example : 501
     */
    @JvmName("kqlevmlognpdolam")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value exportRoutePolicyId
     */
    @JvmName("iasvgsdcbjdubswj")
    public suspend fun exportRoutePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportRoutePolicyId = mapped
    }

    /**
     * @param value importRoutePolicyId
     */
    @JvmName("hahvoijbgjtbcbul")
    public suspend fun importRoutePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importRoutePolicyId = mapped
    }

    /**
     * @param value ASN of PE devices for CE/PE connectivity.Example : 28
     */
    @JvmName("gihaqekraprctpjb")
    public suspend fun peerASN(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerASN = mapped
    }

    /**
     * @param value IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("abgyaxcfvqrrwwkt")
    public suspend fun primaryIpv4Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpv4Prefix = mapped
    }

    /**
     * @param value IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("rdjxiimjfykhqbbe")
    public suspend fun primaryIpv6Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpv6Prefix = mapped
    }

    /**
     * @param value Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("alefakmmmimquqmg")
    public suspend fun secondaryIpv4Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryIpv4Prefix = mapped
    }

    /**
     * @param value Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("wuupwgpucsfthjhi")
    public suspend fun secondaryIpv6Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryIpv6Prefix = mapped
    }

    /**
     * @param value VLAN for CE/PE Layer 3 connectivity.Example : 501
     */
    @JvmName("ithmmiccygmlpyyo")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): Layer3ConfigurationArgs = Layer3ConfigurationArgs(
        exportRoutePolicyId = exportRoutePolicyId,
        importRoutePolicyId = importRoutePolicyId,
        peerASN = peerASN,
        primaryIpv4Prefix = primaryIpv4Prefix,
        primaryIpv6Prefix = primaryIpv6Prefix,
        secondaryIpv4Prefix = secondaryIpv4Prefix,
        secondaryIpv6Prefix = secondaryIpv6Prefix,
        vlanId = vlanId,
    )
}
