@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.ManagementNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration to be used to setup the management network.
 * @property infrastructureVpnConfiguration Configuration for infrastructure vpn.
 * @property workloadVpnConfiguration Configuration for workload vpn.
 */
public data class ManagementNetworkConfigurationArgs(
    public val infrastructureVpnConfiguration: Output<VpnConfigurationPropertiesArgs>,
    public val workloadVpnConfiguration: Output<VpnConfigurationPropertiesArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.ManagementNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.ManagementNetworkConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.ManagementNetworkConfigurationArgs.builder()
            .infrastructureVpnConfiguration(
                infrastructureVpnConfiguration.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .workloadVpnConfiguration(
                workloadVpnConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagementNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class ManagementNetworkConfigurationArgsBuilder internal constructor() {
    private var infrastructureVpnConfiguration: Output<VpnConfigurationPropertiesArgs>? = null

    private var workloadVpnConfiguration: Output<VpnConfigurationPropertiesArgs>? = null

    /**
     * @param value Configuration for infrastructure vpn.
     */
    @JvmName("vdxxdglimmlreuhd")
    public suspend fun infrastructureVpnConfiguration(`value`: Output<VpnConfigurationPropertiesArgs>) {
        this.infrastructureVpnConfiguration = value
    }

    /**
     * @param value Configuration for workload vpn.
     */
    @JvmName("yklchruscsewhrkb")
    public suspend fun workloadVpnConfiguration(`value`: Output<VpnConfigurationPropertiesArgs>) {
        this.workloadVpnConfiguration = value
    }

    /**
     * @param value Configuration for infrastructure vpn.
     */
    @JvmName("ehcerkaeelmnkwbl")
    public suspend fun infrastructureVpnConfiguration(`value`: VpnConfigurationPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureVpnConfiguration = mapped
    }

    /**
     * @param argument Configuration for infrastructure vpn.
     */
    @JvmName("slnqomrnomsmjycp")
    public suspend fun infrastructureVpnConfiguration(argument: suspend VpnConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VpnConfigurationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.infrastructureVpnConfiguration = mapped
    }

    /**
     * @param value Configuration for workload vpn.
     */
    @JvmName("oaopnwnxwabjxsni")
    public suspend fun workloadVpnConfiguration(`value`: VpnConfigurationPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadVpnConfiguration = mapped
    }

    /**
     * @param argument Configuration for workload vpn.
     */
    @JvmName("qvddwxqhynonyglh")
    public suspend fun workloadVpnConfiguration(argument: suspend VpnConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VpnConfigurationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workloadVpnConfiguration = mapped
    }

    internal fun build(): ManagementNetworkConfigurationArgs = ManagementNetworkConfigurationArgs(
        infrastructureVpnConfiguration = infrastructureVpnConfiguration ?: throw
            PulumiNullFieldException("infrastructureVpnConfiguration"),
        workloadVpnConfiguration = workloadVpnConfiguration ?: throw
            PulumiNullFieldException("workloadVpnConfiguration"),
    )
}
