@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.OptionAPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Peering optionA properties
 * @property mtu MTU to use for option A peering.
 * @property peerASN Peer ASN number.Example : 28
 * @property primaryIpv4Prefix IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property primaryIpv6Prefix IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv4Prefix Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv6Prefix Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property vlanId Vlan identifier. Example : 501
 */
public data class OptionAPropertiesArgs(
    public val mtu: Output<Int>? = null,
    public val peerASN: Output<Int>? = null,
    public val primaryIpv4Prefix: Output<String>? = null,
    public val primaryIpv6Prefix: Output<String>? = null,
    public val secondaryIpv4Prefix: Output<String>? = null,
    public val secondaryIpv6Prefix: Output<String>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.OptionAPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.OptionAPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.OptionAPropertiesArgs.builder()
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .peerASN(peerASN?.applyValue({ args0 -> args0 }))
            .primaryIpv4Prefix(primaryIpv4Prefix?.applyValue({ args0 -> args0 }))
            .primaryIpv6Prefix(primaryIpv6Prefix?.applyValue({ args0 -> args0 }))
            .secondaryIpv4Prefix(secondaryIpv4Prefix?.applyValue({ args0 -> args0 }))
            .secondaryIpv6Prefix(secondaryIpv6Prefix?.applyValue({ args0 -> args0 }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OptionAPropertiesArgs].
 */
@PulumiTagMarker
public class OptionAPropertiesArgsBuilder internal constructor() {
    private var mtu: Output<Int>? = null

    private var peerASN: Output<Int>? = null

    private var primaryIpv4Prefix: Output<String>? = null

    private var primaryIpv6Prefix: Output<String>? = null

    private var secondaryIpv4Prefix: Output<String>? = null

    private var secondaryIpv6Prefix: Output<String>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value MTU to use for option A peering.
     */
    @JvmName("rhwyrbskntujkafd")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value Peer ASN number.Example : 28
     */
    @JvmName("pntvnedfhntwfagf")
    public suspend fun peerASN(`value`: Output<Int>) {
        this.peerASN = value
    }

    /**
     * @param value IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("ydvhpjpsnumsjmrq")
    public suspend fun primaryIpv4Prefix(`value`: Output<String>) {
        this.primaryIpv4Prefix = value
    }

    /**
     * @param value IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("subudvepoybyhuqt")
    public suspend fun primaryIpv6Prefix(`value`: Output<String>) {
        this.primaryIpv6Prefix = value
    }

    /**
     * @param value Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("eoghlbisktgfyjyk")
    public suspend fun secondaryIpv4Prefix(`value`: Output<String>) {
        this.secondaryIpv4Prefix = value
    }

    /**
     * @param value Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("tteugbjtuwqnobel")
    public suspend fun secondaryIpv6Prefix(`value`: Output<String>) {
        this.secondaryIpv6Prefix = value
    }

    /**
     * @param value Vlan identifier. Example : 501
     */
    @JvmName("dmrlvbkuvqwkyhkg")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value MTU to use for option A peering.
     */
    @JvmName("autmhjlxvdkkewkg")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value Peer ASN number.Example : 28
     */
    @JvmName("ymcufkbipshfergs")
    public suspend fun peerASN(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerASN = mapped
    }

    /**
     * @param value IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("yeefsfaetwnkdred")
    public suspend fun primaryIpv4Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpv4Prefix = mapped
    }

    /**
     * @param value IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("ldvobabechkrnmpw")
    public suspend fun primaryIpv6Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpv6Prefix = mapped
    }

    /**
     * @param value Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("yhrlkapepoovjfjv")
    public suspend fun secondaryIpv4Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryIpv4Prefix = mapped
    }

    /**
     * @param value Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("niwgiatgnmmbjbkk")
    public suspend fun secondaryIpv6Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryIpv6Prefix = mapped
    }

    /**
     * @param value Vlan identifier. Example : 501
     */
    @JvmName("lejiofvpuehqucoi")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): OptionAPropertiesArgs = OptionAPropertiesArgs(
        mtu = mtu,
        peerASN = peerASN,
        primaryIpv4Prefix = primaryIpv4Prefix,
        primaryIpv6Prefix = primaryIpv6Prefix,
        secondaryIpv4Prefix = secondaryIpv4Prefix,
        secondaryIpv6Prefix = secondaryIpv6Prefix,
        vlanId = vlanId,
    )
}
